/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator.recipes;

import com.yahoo.vespa.curator.Curator;
import org.apache.curator.framework.recipes.atomic.AtomicValue;
import org.apache.curator.framework.recipes.atomic.DistributedAtomicLong;

public class CuratorCounter {
    private final DistributedAtomicLong counter;
    private final String counterPath;

    public CuratorCounter(Curator curator, String counterPath) {
        this.counter = curator.createAtomicCounter(counterPath);
        this.counterPath = counterPath;
    }

    public long next() {
        return this.add(1L);
    }

    public long previous() {
        return this.add(-1L);
    }

    public synchronized long add(long delta) {
        try {
            AtomicValue value = this.counter.add(Long.valueOf(delta));
            if (!value.succeeded()) {
                throw new IllegalStateException("Add did not succeed");
            }
            return (Long)value.postValue();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to add value", e);
        }
    }

    public synchronized void set(long current) {
        try {
            this.counter.trySet(Long.valueOf(current));
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to set value", e);
        }
    }

    public long get() {
        try {
            AtomicValue value = this.counter.get();
            if (!value.succeeded()) {
                throw new RuntimeException("Get did not succeed");
            }
            return (Long)value.postValue();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get value", e);
        }
    }

    public void initialize(long value) {
        try {
            this.counter.initialize(Long.valueOf(value));
        }
        catch (Exception e) {
            throw new IllegalStateException("Error initializing atomic counter", e);
        }
    }

    public String toString() {
        return "curator counter " + this.counterPath;
    }
}

