/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.zookeeper;

import com.google.common.collect.ImmutableSet;
import com.yahoo.net.HostName;
import com.yahoo.text.StringUtilities;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.NIOServerCnxnFactory;

public class RestrictedServerCnxnFactory
extends NIOServerCnxnFactory {
    private static final Logger log = Logger.getLogger(RestrictedServerCnxnFactory.class.getName());

    protected NIOServerCnxn createConnection(SocketChannel socket, SelectionKey selection) throws IOException {
        NIOServerCnxn ret = super.createConnection(socket, selection);
        this.validateRemoteOrClose(socket);
        return ret;
    }

    private void validateRemoteOrClose(SocketChannel socket) {
        try {
            String remoteHost = ((InetSocketAddress)socket.getRemoteAddress()).getHostName();
            if (this.isLocalHost(remoteHost)) {
                return;
            }
            ImmutableSet<String> allowedZooKeeperClients = this.findAllowedZooKeeperClients();
            if (allowedZooKeeperClients.isEmpty()) {
                return;
            }
            if (allowedZooKeeperClients.contains((Object)remoteHost)) {
                return;
            }
            String errorMessage = "Rejecting connection to ZooKeeper from " + remoteHost + ": This cluster only allow connection from hosts in: " + allowedZooKeeperClients;
            log.info(errorMessage);
            socket.shutdownInput();
            socket.shutdownOutput();
        }
        catch (Exception e) {
            log.warning("Unexpected exception: " + e);
        }
    }

    private ImmutableSet<String> findAllowedZooKeeperClients() {
        String environmentAllowedZooKeeperClients = System.getenv("vespa_zkfacade__restrict");
        if (environmentAllowedZooKeeperClients != null) {
            return ImmutableSet.copyOf(this.toHostnameSet(environmentAllowedZooKeeperClients));
        }
        return ImmutableSet.of();
    }

    private Set<String> toHostnameSet(String hostnamesString) {
        HashSet<String> hostnames = new HashSet<String>();
        for (String hostname : StringUtilities.split((String)hostnamesString)) {
            if (hostname.trim().isEmpty()) continue;
            hostnames.add(hostname.trim());
        }
        return hostnames;
    }

    private boolean isLocalHost(String remoteHost) {
        if (remoteHost.equals("localhost")) {
            return true;
        }
        if (remoteHost.equals("localhost.localdomain")) {
            return true;
        }
        return remoteHost.equals(HostName.getLocalhost());
    }
}

