/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator.transaction;

import com.yahoo.transaction.AbstractTransaction;
import com.yahoo.transaction.Transaction;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.transaction.CuratorOperation;
import com.yahoo.vespa.curator.transaction.TransactionChanges;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.curator.framework.api.transaction.CuratorTransactionFinal;

public class CuratorTransaction
extends AbstractTransaction {
    private final Curator curator;
    private boolean prepared = false;

    public CuratorTransaction(Curator curator) {
        this.curator = curator;
    }

    public static CuratorTransaction empty(Curator curator) {
        return new CuratorTransaction(curator);
    }

    public static CuratorTransaction from(CuratorOperation operation, Curator curator) {
        CuratorTransaction transaction = new CuratorTransaction(curator);
        transaction.add(operation);
        return transaction;
    }

    public static CuratorTransaction from(List<CuratorOperation> operations, Curator curator) {
        CuratorTransaction transaction = new CuratorTransaction(curator);
        for (Transaction.Operation operation : operations) {
            transaction.add(operation);
        }
        return transaction;
    }

    public void prepare() {
        TransactionChanges changes = new TransactionChanges();
        for (Transaction.Operation operation : this.operations()) {
            ((CuratorOperation)operation).check(this.curator, changes);
        }
        this.prepared = true;
    }

    public void commit() {
        try {
            if (!this.prepared) {
                this.prepare();
            }
            org.apache.curator.framework.api.transaction.CuratorTransaction transaction = this.curator.framework().inTransaction();
            for (Transaction.Operation operation : this.operations()) {
                transaction = ((CuratorOperation)operation).and(transaction);
            }
            ((CuratorTransactionFinal)transaction).commit();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return String.join((CharSequence)",", this.operations().stream().map(operation -> operation.toString()).collect(Collectors.toList()));
    }
}

