/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator.recipes;

import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.recipes.CuratorLockException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.apache.curator.framework.recipes.locks.InterProcessLock;

public class CuratorLock
implements Lock {
    private final InterProcessLock mutex;

    public CuratorLock(Curator curator, String lockPath) {
        this.mutex = curator.createMutex(lockPath);
    }

    public boolean hasLock() {
        return this.mutex.isAcquiredInThisProcess();
    }

    @Override
    public void lock() {
        try {
            this.mutex.acquire();
        }
        catch (Exception e) {
            throw new CuratorLockException(e);
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean tryLock() {
        try {
            return this.tryLock(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new CuratorLockException(e);
        }
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        try {
            return this.mutex.acquire(time, unit);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CuratorLockException(e);
        }
    }

    @Override
    public void unlock() {
        try {
            this.mutex.release();
        }
        catch (Exception e) {
            throw new CuratorLockException(e);
        }
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.mutex.toString();
    }
}

