/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator.recipes;

import com.yahoo.vespa.curator.Curator;
import org.apache.curator.framework.recipes.atomic.AtomicValue;
import org.apache.curator.framework.recipes.atomic.DistributedAtomicLong;

public class CuratorCounter {
    private final DistributedAtomicLong counter;
    private final String counterPath;

    public CuratorCounter(Curator curator, String counterPath) {
        this.counter = curator.createAtomicCounter(counterPath);
        this.counterPath = counterPath;
    }

    public synchronized long next() {
        try {
            AtomicValue value = this.counter.increment();
            if (!value.succeeded()) {
                throw new IllegalStateException("Increment did not succeed");
            }
            return (Long)value.postValue();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to get next value", e);
        }
    }

    public synchronized long previous() {
        try {
            AtomicValue value = this.counter.subtract(Long.valueOf(1L));
            if (!value.succeeded()) {
                throw new IllegalStateException("Decrement did not succeed");
            }
            return (Long)value.postValue();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to get previous value", e);
        }
    }

    public synchronized void set(long current) {
        try {
            this.counter.trySet(Long.valueOf(current));
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to set value", e);
        }
    }

    public long get() {
        try {
            AtomicValue value = this.counter.get();
            if (!value.succeeded()) {
                throw new RuntimeException("Get did not succeed");
            }
            return (Long)value.postValue();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get value", e);
        }
    }

    public void initialize(long value) {
        try {
            this.counter.initialize(Long.valueOf(value));
        }
        catch (Exception e) {
            throw new IllegalStateException("Error initializing atomic counter", e);
        }
    }

    public String toString() {
        return "curator counter " + this.counterPath;
    }
}

