/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator;

import com.yahoo.vespa.curator.Curator;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;

class PathChildrenCacheWrapper
implements Curator.DirectoryCache {
    private final PathChildrenCache wrapped;

    public PathChildrenCacheWrapper(CuratorFramework curatorFramework, String path, boolean cacheData, boolean dataIsCompressed, ExecutorService executorService) {
        this.wrapped = new PathChildrenCache(curatorFramework, path, cacheData, dataIsCompressed, executorService);
    }

    @Override
    public void start() {
        try {
            this.wrapped.start(PathChildrenCache.StartMode.BUILD_INITIAL_CACHE);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not start the Curator cache", e);
        }
    }

    @Override
    public void addListener(PathChildrenCacheListener listener) {
        this.wrapped.getListenable().addListener((Object)listener);
    }

    @Override
    public List<ChildData> getCurrentData() {
        return this.wrapped.getCurrentData();
    }

    @Override
    public void close() {
        try {
            this.wrapped.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Exception closing curator cache", e);
        }
    }
}

