/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator.transaction;

import java.util.HashSet;
import java.util.Set;

public class TransactionChanges {
    private final Set<String> createdPaths = new HashSet<String>();
    private final Set<String> deletedPaths = new HashSet<String>();

    public boolean create(String path) {
        return this.createdPaths.contains(path);
    }

    public boolean createsChildrenOf(String parentPath) {
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        for (String createdPath : this.createdPaths) {
            if (!createdPath.startsWith(parentPath)) continue;
            return true;
        }
        return false;
    }

    public void addCreate(String path) {
        this.deletedPaths.remove(path);
        this.createdPaths.add(path);
    }

    public boolean delete(String path) {
        return this.deletedPaths.contains(path);
    }

    public void addDelete(String path) {
        this.createdPaths.remove(path);
        this.deletedPaths.add(path);
    }

    public String toString() {
        return "Transaction changes: CREATES " + this.createdPaths + " DELETES " + this.deletedPaths;
    }
}

