/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.net.HostName;
import com.yahoo.path.Path;
import com.yahoo.vespa.curator.CuratorCompletionWaiter;
import com.yahoo.vespa.curator.DNSResolvingFixerZooKeeperFactory;
import com.yahoo.vespa.curator.NodeCacheWrapper;
import com.yahoo.vespa.curator.PathChildrenCacheWrapper;
import com.yahoo.vespa.zookeeper.ZooKeeperServer;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.transaction.CuratorTransaction;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.curator.framework.api.transaction.CuratorTransactionFinal;
import org.apache.curator.framework.recipes.atomic.DistributedAtomicLong;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.ZookeeperFactory;
import org.apache.zookeeper.KeeperException;

public class Curator
implements AutoCloseable {
    private static final long UNKNOWN_HOST_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(30L);
    private static final int ZK_SESSION_TIMEOUT = 30000;
    private static final int ZK_CONNECTION_TIMEOUT = 30000;
    private static final int BASE_SLEEP_TIME = 1000;
    private static final int MAX_RETRIES = 10;
    protected final RetryPolicy retryPolicy;
    private final CuratorFramework curatorFramework;
    private final String connectionSpec;
    private final String zooKeeperEnsembleConnectionSpec;
    private final int zooKeeperEnsembleCount;

    public static Curator create(String connectionSpec) {
        return new Curator(connectionSpec, connectionSpec);
    }

    @Inject
    public Curator(ConfigserverConfig configserverConfig, ZooKeeperServer server) {
        this(configserverConfig, Curator.createConnectionSpec(configserverConfig));
    }

    private Curator(ConfigserverConfig configserverConfig, String zooKeeperEnsembleConnectionSpec) {
        this(configserverConfig.zookeeperLocalhostAffinity() ? Curator.createConnectionSpecForLocalhost(configserverConfig) : zooKeeperEnsembleConnectionSpec, zooKeeperEnsembleConnectionSpec);
    }

    private Curator(String connectionSpec, String zooKeeperEnsembleConnectionSpec) {
        this(connectionSpec, zooKeeperEnsembleConnectionSpec, retryPolicy -> CuratorFrameworkFactory.builder().retryPolicy(retryPolicy).sessionTimeoutMs(30000).connectionTimeoutMs(30000).connectString(connectionSpec).zookeeperFactory((ZookeeperFactory)new DNSResolvingFixerZooKeeperFactory(UNKNOWN_HOST_TIMEOUT_MILLIS)).build());
    }

    protected Curator(String connectionSpec, String zooKeeperEnsembleConnectionSpec, Function<RetryPolicy, CuratorFramework> curatorFactory) {
        this(connectionSpec, zooKeeperEnsembleConnectionSpec, curatorFactory, (RetryPolicy)new ExponentialBackoffRetry(1000, 10));
    }

    private Curator(String connectionSpec, String zooKeeperEnsembleConnectionSpec, Function<RetryPolicy, CuratorFramework> curatorFactory, RetryPolicy retryPolicy) {
        this.connectionSpec = connectionSpec;
        this.retryPolicy = retryPolicy;
        this.curatorFramework = curatorFactory.apply(retryPolicy);
        if (this.curatorFramework != null) {
            Curator.validateConnectionSpec(connectionSpec);
            Curator.validateConnectionSpec(zooKeeperEnsembleConnectionSpec);
            this.addFakeListener();
            this.curatorFramework.start();
        }
        this.zooKeeperEnsembleConnectionSpec = zooKeeperEnsembleConnectionSpec;
        this.zooKeeperEnsembleCount = zooKeeperEnsembleConnectionSpec.split(",").length;
    }

    static String createConnectionSpec(ConfigserverConfig config) {
        StringBuilder connectionSpec = new StringBuilder();
        for (int i = 0; i < config.zookeeperserver().size(); ++i) {
            if (connectionSpec.length() > 0) {
                connectionSpec.append(',');
            }
            ConfigserverConfig.Zookeeperserver server = config.zookeeperserver(i);
            connectionSpec.append(server.hostname());
            connectionSpec.append(':');
            connectionSpec.append(server.port());
        }
        return connectionSpec.toString();
    }

    static String createConnectionSpecForLocalhost(ConfigserverConfig config) {
        String thisServer = HostName.getLocalhost();
        for (int i = 0; i < config.zookeeperserver().size(); ++i) {
            ConfigserverConfig.Zookeeperserver server = config.zookeeperserver(i);
            if (!thisServer.equals(server.hostname())) continue;
            return String.format("%s:%d", server.hostname(), server.port());
        }
        throw new IllegalArgumentException("Unable to create connect string to localhost: There is no localhost server specified in config: " + config);
    }

    private static void validateConnectionSpec(String connectionSpec) {
        if (connectionSpec == null || connectionSpec.isEmpty()) {
            throw new IllegalArgumentException(String.format("Connections spec '%s' is not valid", connectionSpec));
        }
    }

    public String connectionSpec() {
        return this.connectionSpec;
    }

    public DistributedAtomicLong createAtomicCounter(String path) {
        return new DistributedAtomicLong(this.curatorFramework, path, (RetryPolicy)new ExponentialBackoffRetry(1000, 10));
    }

    public InterProcessLock createMutex(String lockPath) {
        return new InterProcessMutex(this.curatorFramework, lockPath);
    }

    private void addFakeListener() {
        this.curatorFramework.getConnectionStateListenable().addListener((Object)new ConnectionStateListener(){

            public void stateChanged(CuratorFramework curatorFramework, ConnectionState connectionState) {
            }
        });
    }

    public CompletionWaiter getCompletionWaiter(Path waiterPath, int numMembers, String id) {
        return CuratorCompletionWaiter.create(this.curatorFramework, waiterPath, numMembers, id);
    }

    public CompletionWaiter createCompletionWaiter(Path parentPath, String waiterNode, int numMembers, String id) {
        return CuratorCompletionWaiter.createAndInitialize(this, parentPath, waiterNode, numMembers, id);
    }

    public DirectoryCache createDirectoryCache(String path, boolean cacheData, boolean dataIsCompressed, ExecutorService executorService) {
        return new PathChildrenCacheWrapper(this.framework(), path, cacheData, dataIsCompressed, executorService);
    }

    public FileCache createFileCache(String path, boolean dataIsCompressed) {
        return new NodeCacheWrapper(this.framework(), path, dataIsCompressed);
    }

    public boolean exists(Path path) {
        try {
            return this.framework().checkExists().forPath(path.getAbsolute()) != null;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not check existence of " + path.getAbsolute(), e);
        }
    }

    public void set(Path path, byte[] data) {
        String absolutePath = path.getAbsolute();
        try {
            if (!this.exists(path)) {
                this.framework().create().creatingParentsIfNeeded().forPath(absolutePath, data);
            } else {
                this.framework().setData().forPath(absolutePath, data);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set data at " + absolutePath, e);
        }
    }

    public void create(Path path) {
        if (this.exists(path)) {
            return;
        }
        String absolutePath = path.getAbsolute();
        try {
            this.framework().create().creatingParentsIfNeeded().forPath(absolutePath, new byte[0]);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create " + absolutePath, e);
        }
    }

    public void createAtomically(Path ... paths) {
        try {
            CuratorTransaction transaction = this.framework().inTransaction();
            for (Path path : paths) {
                if (this.exists(path)) continue;
                transaction = ((CuratorTransactionBridge)transaction.create().forPath(path.getAbsolute(), new byte[0])).and();
            }
            ((CuratorTransactionFinal)transaction).commit();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create " + Arrays.toString(paths), e);
        }
    }

    public void delete(Path path) {
        if (!this.exists(path)) {
            return;
        }
        try {
            this.framework().delete().guaranteed().deletingChildrenIfNeeded().forPath(path.getAbsolute());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not delete " + path.getAbsolute(), e);
        }
    }

    public List<String> getChildren(Path path) {
        if (!this.exists(path)) {
            return Collections.emptyList();
        }
        try {
            return (List)this.framework().getChildren().forPath(path.getAbsolute());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get children of " + path.getAbsolute(), e);
        }
    }

    public Optional<byte[]> getData(Path path) {
        if (!this.exists(path)) {
            return Optional.empty();
        }
        try {
            return Optional.of(this.framework().getData().forPath(path.getAbsolute()));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get data at " + path.getAbsolute(), e);
        }
    }

    public CuratorFramework framework() {
        return this.curatorFramework;
    }

    @Override
    public void close() {
        this.curatorFramework.close();
    }

    public String zooKeeperEnsembleConnectionSpec() {
        return this.zooKeeperEnsembleConnectionSpec;
    }

    public int zooKeeperEnsembleCount() {
        return this.zooKeeperEnsembleCount;
    }

    public static interface FileCache {
        public void start();

        public void addListener(NodeCacheListener var1);

        public ChildData getCurrentData();

        public void close();
    }

    public static interface DirectoryCache {
        public void start();

        public void addListener(PathChildrenCacheListener var1);

        public List<ChildData> getCurrentData();

        public void close();
    }

    public static interface CompletionWaiter {
        public void awaitCompletion(Duration var1);

        public void notifyCompletion();
    }
}

