/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator;

import com.yahoo.log.LogLevel;
import com.yahoo.path.Path;
import com.yahoo.vespa.curator.CompletionTimeoutException;
import com.yahoo.vespa.curator.Curator;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.curator.framework.CuratorFramework;

class CuratorCompletionWaiter
implements Curator.CompletionWaiter {
    private static final Logger log = Logger.getLogger(CuratorCompletionWaiter.class.getName());
    private final CuratorFramework curator;
    private final String barrierPath;
    private final String myId;
    private final int memberQty;
    private final Clock clock;

    CuratorCompletionWaiter(int barrierMembers, CuratorFramework curator, String barrierPath, String myId, Clock clock) {
        this.memberQty = barrierMembers;
        this.myId = barrierPath + "/" + myId;
        this.curator = curator;
        this.barrierPath = barrierPath;
        this.clock = clock;
    }

    @Override
    public void awaitCompletion(Duration timeout) {
        List<String> respondents;
        try {
            log.log((Level)LogLevel.DEBUG, "Synchronizing on barrier " + this.barrierPath);
            respondents = this.awaitInternal(timeout);
            log.log((Level)LogLevel.DEBUG, "Done synchronizing on barrier " + this.barrierPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (respondents.size() < this.memberQty) {
            throw new CompletionTimeoutException("Timed out waiting for peer config servers to complete operation. Got response from: " + respondents + ". Timeout passed as argument was " + timeout.toMillis() + " ms");
        }
    }

    private List<String> awaitInternal(Duration timeout) throws Exception {
        List respondents;
        Instant endTime = this.clock.instant().plus(timeout);
        while ((respondents = (List)this.curator.getChildren().forPath(this.barrierPath)).size() < this.memberQty) {
            Thread.sleep(100L);
            if (this.clock.instant().isBefore(endTime)) continue;
        }
        return respondents;
    }

    @Override
    public void notifyCompletion() {
        try {
            this.notifyInternal();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void notifyInternal() throws Exception {
        this.curator.create().forPath(this.myId);
    }

    public String toString() {
        return "'" + this.barrierPath + "', " + this.memberQty + " members";
    }

    public static Curator.CompletionWaiter create(CuratorFramework curator, Path barrierPath, int numMembers, String id) {
        return new CuratorCompletionWaiter(numMembers, curator, barrierPath.getAbsolute(), id, Clock.systemUTC());
    }

    public static Curator.CompletionWaiter createAndInitialize(Curator curator, Path parentPath, String waiterNode, int numMembers, String id) {
        Path waiterPath = parentPath.append(waiterNode);
        curator.delete(waiterPath);
        curator.createAtomically(parentPath, waiterPath);
        return new CuratorCompletionWaiter(numMembers, curator.framework(), waiterPath.getAbsolute(), id, Clock.systemUTC());
    }
}

