/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.curator.mock;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

class MemoryFileSystem
extends FileSystem {
    private Node root = new Node(null, "");

    MemoryFileSystem() {
    }

    @Override
    public FileSystemProvider provider() {
        throw new UnsupportedOperationException("Not implemented in MemoryFileSystem");
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return Collections.singleton(Paths.get("/", new String[0]));
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        throw new UnsupportedOperationException("Not implemented in MemoryFileSystem");
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return Collections.emptySet();
    }

    @Override
    public Path getPath(String first, String ... more) {
        return Paths.get(first, more);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        throw new UnsupportedOperationException("Not implemented in MemoryFileSystem");
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException("Not implemented in MemoryFileSystem");
    }

    @Override
    public WatchService newWatchService() throws IOException {
        throw new UnsupportedOperationException("Not implemented in MemoryFileSystem");
    }

    public Node root() {
        return this.root;
    }

    public void replaceRoot(Node newRoot) {
        this.root = newRoot;
    }

    public String dumpState() {
        StringBuilder b = new StringBuilder();
        this.root.writeRecursivelyTo(b, "");
        return b.toString();
    }

    public static class Node
    implements Cloneable {
        private final Node parent;
        private final String name;
        private byte[] content;
        private Map<String, Node> children = new LinkedHashMap<String, Node>();

        private Node(Node parent, String name) {
            this(parent, name, new byte[0]);
        }

        private Node(Node parent, String name, byte[] content) {
            this.parent = parent;
            this.name = name;
            this.content = Arrays.copyOf(content, content.length);
        }

        public byte[] getContent() {
            return Arrays.copyOf(this.content, this.content.length);
        }

        public void setContent(byte[] content) {
            this.content = Arrays.copyOf(content, content.length);
        }

        public Node getNode(Path path, boolean create) {
            if (path.getNameCount() == 0 || path.toString().isEmpty()) {
                return this;
            }
            String childName = path.getName(0).toString();
            Node child = this.children.get(childName);
            if (child == null) {
                if (create) {
                    child = this.add(childName);
                } else {
                    return null;
                }
            }
            if (path.getNameCount() == 1) {
                return child;
            }
            return child.getNode(path.subpath(1, path.getNameCount()), create);
        }

        public Node parent() {
            return this.parent;
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public String name() {
            return this.name;
        }

        public Node add(String name) {
            if (this.children.containsKey(name)) {
                return this.children.get(name);
            }
            Node child = new Node(this, name);
            this.children.put(name, child);
            return child;
        }

        public Node add(Node node) {
            return this.children.put(node.name(), node);
        }

        public Node remove(String name) {
            return this.children.remove(name);
        }

        public Map<String, Node> children() {
            return Collections.unmodifiableMap(this.children);
        }

        public void writeRecursivelyTo(StringBuilder b, String pathPrefix) {
            String path = (pathPrefix.equals("/") ? "" : pathPrefix) + "/" + this.name;
            b.append(path);
            if (this.content.length > 0) {
                b.append(" [content: ").append(this.content.length).append(" bytes]");
            }
            b.append("\n");
            for (Node child : this.children.values()) {
                child.writeRecursivelyTo(b, path);
            }
        }

        public String toString() {
            return "directory '" + this.name() + "'";
        }

        public Node clone() {
            try {
                Node clone = (Node)super.clone();
                HashMap<String, Node> cloneChildren = new HashMap<String, Node>();
                for (Map.Entry<String, Node> child : this.children.entrySet()) {
                    cloneChildren.put(child.getKey(), child.getValue().clone());
                }
                clone.children = cloneChildren;
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("Won't happen");
            }
        }
    }
}

