/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.transaction;

import com.yahoo.transaction.Transaction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public abstract class AbstractTransaction
implements Transaction {
    private static final Logger log = Logger.getLogger(AbstractTransaction.class.getName());
    private final List<Transaction.Operation> operations = new ArrayList<Transaction.Operation>();

    protected AbstractTransaction() {
    }

    @Override
    public Transaction add(Transaction.Operation operation) {
        this.operations.add(operation);
        return this;
    }

    @Override
    public Transaction add(List<Transaction.Operation> operations) {
        this.operations.addAll(operations);
        return this;
    }

    @Override
    public List<Transaction.Operation> operations() {
        return this.operations;
    }

    @Override
    public void rollbackOrLog() {
        log.severe("The following operations were incorrectly committed and probably require manual correction: " + this.operations());
    }

    @Override
    public void close() {
        this.operations.clear();
    }
}

