/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.slime;

import com.yahoo.compress.Compressor;
import com.yahoo.slime.BinaryDecoder;
import com.yahoo.slime.BinaryEncoder;
import com.yahoo.slime.Slime;
import com.yahoo.slime.Type;

public class BinaryFormat {
    static long encode_zigzag(long x) {
        return x << 1 ^ x >> 63;
    }

    static long decode_zigzag(long x) {
        return x >>> 1 ^ -(x & 1L);
    }

    static long encode_double(double x) {
        return Double.doubleToRawLongBits(x);
    }

    static double decode_double(long x) {
        return Double.longBitsToDouble(x);
    }

    static byte encode_type_and_meta(int type, int meta) {
        return (byte)(meta << 3 | type & 7);
    }

    static Type decode_type(byte type_and_meta) {
        return Type.asType(type_and_meta & 7);
    }

    static int decode_meta(byte type_and_meta) {
        return (type_and_meta & 0xFF) >>> 3;
    }

    public static byte[] encode(Slime slime) {
        return new BinaryEncoder().encode(slime).toArray();
    }

    public static Compressor.Compression encode_and_compress(Slime slime, Compressor compressor) {
        return new BinaryEncoder().encode(slime).compress(compressor);
    }

    public static Slime decode(byte[] data) {
        BinaryDecoder decoder = new BinaryDecoder();
        return decoder.decode(data);
    }

    public static Slime decode(byte[] data, int offset, int length) {
        BinaryDecoder decoder = new BinaryDecoder();
        return decoder.decode(data, offset, length);
    }
}

