/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.yolean;

import com.yahoo.yolean.UncheckedInterruptedException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;
import java.util.function.Function;

public class Exceptions {
    public static String toMessageString(Throwable t) {
        StringBuilder b = new StringBuilder();
        String lastMessage = null;
        while (t != null) {
            String message = Exceptions.getMessage(t);
            if (message != null && !message.isEmpty() && !message.equals(lastMessage)) {
                if (b.length() > 0) {
                    b.append(": ");
                }
                b.append(message);
                lastMessage = message;
            }
            t = t.getCause();
        }
        return b.toString();
    }

    private static String getMessage(Throwable t) {
        String message = t.getMessage();
        if (t.getCause() == null) {
            if (message == null) {
                return t.getClass().getSimpleName();
            }
        } else {
            if (message == null) {
                return null;
            }
            if (message.equals(t.getCause().getClass().getName() + ": " + t.getCause().getMessage())) {
                return null;
            }
        }
        return message;
    }

    public static <T extends Throwable> Optional<T> findCause(Throwable t, Class<T> clazz) {
        while (t != null) {
            if (clazz.isInstance(t)) {
                return Optional.of((Throwable)clazz.cast(t));
            }
            t = t.getCause();
        }
        return Optional.empty();
    }

    public static void uncheck(RunnableThrowingIOException runnable) {
        try {
            runnable.run();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void uncheck(RunnableThrowingIOException runnable, String format, String ... args) {
        try {
            runnable.run();
        }
        catch (IOException e) {
            String message = String.format(format, args);
            throw new UncheckedIOException(message, e);
        }
    }

    public static <T extends IOException> void uncheckAndIgnore(RunnableThrowingIOException runnable, Class<T> exceptionToIgnore) {
        try {
            runnable.run();
        }
        catch (UncheckedIOException e) {
            IOException cause = e.getCause();
            if (cause == null) {
                throw e;
            }
            try {
                cause.getClass().asSubclass(exceptionToIgnore);
            }
            catch (ClassCastException f) {
                throw e;
            }
        }
        catch (IOException e) {
            try {
                e.getClass().asSubclass(exceptionToIgnore);
            }
            catch (ClassCastException f) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static <T, R> Function<T, R> uncheck(FunctionThrowingIOException<T, R> function) {
        return t -> Exceptions.uncheck(() -> function.map(t));
    }

    public static <T> T uncheck(SupplierThrowingIOException<T> supplier) {
        try {
            return supplier.get();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> T uncheck(SupplierThrowingIOException<T> supplier, String format, String ... args) {
        try {
            return supplier.get();
        }
        catch (IOException e) {
            String message = String.format(format, args);
            throw new UncheckedIOException(message, e);
        }
    }

    public static <R, T extends IOException> R uncheckAndIgnore(SupplierThrowingIOException<R> supplier, Class<T> exceptionToIgnore) {
        try {
            return supplier.get();
        }
        catch (UncheckedIOException e) {
            IOException cause = e.getCause();
            if (cause == null) {
                throw e;
            }
            try {
                cause.getClass().asSubclass(exceptionToIgnore);
            }
            catch (ClassCastException f) {
                throw e;
            }
            return null;
        }
        catch (IOException e) {
            try {
                e.getClass().asSubclass(exceptionToIgnore);
            }
            catch (ClassCastException f) {
                throw new UncheckedIOException(e);
            }
            return null;
        }
    }

    public static void uncheckInterrupted(RunnableThrowingInterruptedException runnable) {
        try {
            runnable.run();
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e, false);
        }
    }

    public static void uncheckInterruptedAndRestoreFlag(RunnableThrowingInterruptedException runnable) {
        try {
            runnable.run();
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e, true);
        }
    }

    public static <T> T uncheckInterrupted(SupplierThrowingInterruptedException<T> supplier) {
        try {
            return supplier.get();
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
    }

    public static RuntimeException throwUnchecked(Throwable e) {
        Exceptions.throwUncheckedImpl(e);
        return new RuntimeException();
    }

    private static <T extends Throwable> void throwUncheckedImpl(Throwable t) throws T {
        throw t;
    }

    @FunctionalInterface
    public static interface RunnableThrowingIOException {
        public void run() throws IOException;
    }

    @FunctionalInterface
    public static interface FunctionThrowingIOException<T, R> {
        public R map(T var1) throws IOException;
    }

    @FunctionalInterface
    public static interface SupplierThrowingIOException<T> {
        public T get() throws IOException;
    }

    @FunctionalInterface
    public static interface RunnableThrowingInterruptedException {
        public void run() throws InterruptedException;
    }

    @FunctionalInterface
    public static interface SupplierThrowingInterruptedException<T> {
        public T get() throws InterruptedException;
    }
}

