/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.text;

public class PositionedString {
    private final String s;
    private int p;

    public PositionedString(String string) {
        this.s = string;
    }

    public String string() {
        return this.s;
    }

    public int position() {
        return this.p;
    }

    public void setPosition(int position) {
        this.p = position;
    }

    public void consume(char c) {
        if (this.s.charAt(this.p++) != c) {
            throw new IllegalArgumentException("Expected '" + c + "' " + this.at(this.p - 1));
        }
    }

    public void consumeSpaces() {
        while (Character.isWhitespace(this.s.charAt(this.p))) {
            ++this.p;
        }
    }

    public boolean consumeOptional(char c) {
        if (this.s.charAt(this.p) != c) {
            return false;
        }
        ++this.p;
        return true;
    }

    public boolean peek(char c) {
        return this.s.charAt(this.p) == c;
    }

    public int indexOf(char c) {
        return this.s.indexOf(c, this.p);
    }

    public void skip(int n) {
        this.p += n;
    }

    public String consumeTo(char c) {
        int nextC = this.indexOf(c);
        if (nextC < 0) {
            throw new IllegalArgumentException("Expected a string terminated by '" + c + "' " + this.at());
        }
        String value = this.substring(nextC);
        this.p = nextC;
        return value;
    }

    public String consumeToPosition(int position) {
        String consumed = this.substring(position);
        this.p = position;
        return consumed;
    }

    public String substring(int end) {
        return this.string().substring(this.position(), end);
    }

    public String substring() {
        return this.string().substring(this.position());
    }

    public String at() {
        return this.at(this.p);
    }

    public String at(int position) {
        return "starting at position " + position + " but was '" + this.s.charAt(position) + "'";
    }

    public String toString() {
        return this.s;
    }
}

