/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.impl;

import com.yahoo.tensor.Label;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.impl.LabelCache;
import com.yahoo.tensor.impl.TensorAddressAny;
import java.util.Arrays;

final class TensorAddressAnyN
extends TensorAddressAny {
    private final Label[] labels;

    TensorAddressAnyN(Label[] labels) {
        if (labels.length < 1) {
            throw new IllegalArgumentException("Need at least 1 label");
        }
        this.labels = labels;
    }

    @Override
    public int size() {
        return this.labels.length;
    }

    @Override
    public Label objectLabel(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException("Index is not in [0," + (this.size() - 1) + "]: " + i);
        }
        return this.labels[i];
    }

    @Override
    public TensorAddress withLabel(int labelIndex, long label) {
        Label[] copy = Arrays.copyOf(this.labels, this.labels.length);
        copy[labelIndex] = LabelCache.GLOBAL.getOrCreateLabel(label);
        return new TensorAddressAnyN(copy);
    }

    public int hashCode() {
        int result = 1;
        for (Label label : this.labels) {
            result = 31 * result + label.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        TensorAddressAnyN any;
        block4: {
            block3: {
                if (!(o instanceof TensorAddressAnyN)) break block3;
                any = (TensorAddressAnyN)o;
                if (this.size() == any.size()) break block4;
            }
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.labels[i].isEqualTo(any.labels[i])) continue;
            return false;
        }
        return true;
    }
}

