/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor;

import com.yahoo.tensor.Label;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.impl.LabelCache;
import com.yahoo.tensor.impl.TensorAddressAny;

public class PartialAddress {
    private final String[] dimensionNames;
    private final Label[] labels;

    private PartialAddress(Builder builder) {
        this.dimensionNames = builder.dimensionNames;
        this.labels = builder.labels;
        builder.dimensionNames = null;
        builder.labels = null;
    }

    public String dimension(int i) {
        return this.dimensionNames[i];
    }

    public Label objectLabel(String dimensionName) {
        for (int i = 0; i < this.dimensionNames.length; ++i) {
            if (!this.dimensionNames[i].equals(dimensionName)) continue;
            return this.labels[i];
        }
        return LabelCache.INVALID_INDEX_LABEL;
    }

    public long numericLabel(String dimensionName) {
        return this.objectLabel(dimensionName).asNumeric();
    }

    public String label(String dimensionName) {
        return this.objectLabel(dimensionName).asString();
    }

    public Label objectLabel(int i) {
        if (i >= this.size()) {
            throw new IllegalArgumentException("No label at position " + i + " in " + String.valueOf(this));
        }
        return this.labels[i];
    }

    public String label(int i) {
        return this.objectLabel(i).asString();
    }

    public int size() {
        return this.dimensionNames.length;
    }

    public TensorAddress asAddress(TensorType type) {
        if (type.rank() != this.size()) {
            throw new IllegalArgumentException(String.valueOf(type) + " has a different rank than " + String.valueOf(this));
        }
        Label[] labels = new Label[this.labels.length];
        for (int i = 0; i < type.dimensions().size(); ++i) {
            Label label = this.objectLabel(type.dimensions().get(i).name());
            if (label.isEqualTo(LabelCache.INVALID_INDEX_LABEL)) {
                throw new IllegalArgumentException(String.valueOf(type) + " dimension names does not match " + String.valueOf(this));
            }
            labels[i] = label;
        }
        return TensorAddressAny.ofUnsafe(labels);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("Partial address {");
        for (int i = 0; i < this.dimensionNames.length; ++i) {
            b.append(this.dimensionNames[i]).append(":").append(this.label(i)).append(", ");
        }
        if (this.size() > 0) {
            b.setLength(b.length() - 2);
        }
        return b.toString();
    }

    public static class Builder {
        private String[] dimensionNames;
        private Label[] labels;
        private int index = 0;

        public Builder(int size) {
            this.dimensionNames = new String[size];
            this.labels = new Label[size];
        }

        public Builder add(String dimensionName, Label label) {
            this.dimensionNames[this.index] = dimensionName;
            this.labels[this.index] = label;
            ++this.index;
            return this;
        }

        public Builder add(String dimensionName, long label) {
            this.dimensionNames[this.index] = dimensionName;
            this.labels[this.index] = LabelCache.GLOBAL.getOrCreateLabel(label);
            ++this.index;
            return this;
        }

        public Builder add(String dimensionName, String label) {
            this.dimensionNames[this.index] = dimensionName;
            this.labels[this.index] = LabelCache.GLOBAL.getOrCreateLabel(label);
            ++this.index;
            return this;
        }

        public PartialAddress build() {
            return new PartialAddress(this);
        }
    }
}

