/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.slime;

import com.yahoo.slime.ArrayInserter;
import com.yahoo.slime.BinaryFormat;
import com.yahoo.slime.BufferedInput;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inserter;
import com.yahoo.slime.ObjectSymbolInserter;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeInserter;
import com.yahoo.slime.SymbolTable;
import com.yahoo.slime.Type;
import com.yahoo.slime.Utf8Codec;

final class BinaryDecoder {
    BufferedInput in;
    private final SlimeInserter slimeInserter = new SlimeInserter(null);
    private final ArrayInserter arrayInserter = new ArrayInserter(null);
    private final ObjectSymbolInserter objectInserter = new ObjectSymbolInserter(null, 0);

    public Slime decode(byte[] bytes) {
        return this.decode(bytes, 0, bytes.length);
    }

    public Slime decode(byte[] bytes, int offset, int length) {
        Slime slime = new Slime();
        this.in = new BufferedInput(bytes, offset, length);
        BinaryDecoder.decodeSymbolTable(this.in, slime.symbolTable());
        this.decodeValue(this.slimeInserter.adjust(slime));
        if (this.in.failed()) {
            slime.wrap("partial_result");
            slime.get().setData("offending_input", this.in.getOffending());
            slime.get().setString("error_message", this.in.getErrorMessage());
        }
        return slime;
    }

    long read_bytes_le(int bytes) {
        long value = 0L;
        int shift = 0;
        for (int i = 0; i < bytes; ++i) {
            long b = this.in.getByte();
            value |= (b & 0xFFL) << shift;
            shift += 8;
        }
        return value;
    }

    long read_bytes_be(int bytes) {
        long value = 0L;
        int shift = 56;
        for (int i = 0; i < bytes; ++i) {
            long b = this.in.getByte();
            value |= (b & 0xFFL) << shift;
            shift -= 8;
        }
        return value;
    }

    Cursor decodeNIX(Inserter inserter) {
        return inserter.insertNIX();
    }

    Cursor decodeBOOL(Inserter inserter, int meta) {
        return inserter.insertBOOL(meta != 0);
    }

    Cursor decodeLONG(Inserter inserter, int meta) {
        long encoded = this.read_bytes_le(meta);
        return inserter.insertLONG(BinaryFormat.decode_zigzag(encoded));
    }

    Cursor decodeDOUBLE(Inserter inserter, int meta) {
        long encoded = this.read_bytes_be(meta);
        return inserter.insertDOUBLE(BinaryFormat.decode_double(encoded));
    }

    Cursor decodeSTRING(Inserter inserter, int meta) {
        int size = this.in.read_size(meta);
        byte[] image = this.in.getBytes(size);
        return inserter.insertSTRING(image);
    }

    Cursor decodeDATA(Inserter inserter, int meta) {
        int size = this.in.read_size(meta);
        byte[] image = this.in.getBytes(size);
        return inserter.insertDATA(image);
    }

    Cursor decodeARRAY(Inserter inserter, int meta) {
        Cursor cursor = inserter.insertARRAY();
        int size = this.in.read_size(meta);
        for (int i = 0; i < size; ++i) {
            this.decodeValue(this.arrayInserter.adjust(cursor));
        }
        return cursor;
    }

    Cursor decodeOBJECT(Inserter inserter, int meta) {
        Cursor cursor = inserter.insertOBJECT();
        int size = this.in.read_size(meta);
        for (int i = 0; i < size; ++i) {
            int symbol = this.in.read_cmpr_int();
            this.decodeValue(this.objectInserter.adjust(cursor, symbol));
        }
        return cursor;
    }

    Cursor decodeValue(Inserter inserter, Type type, int meta) {
        switch (type) {
            case NIX: {
                return this.decodeNIX(inserter);
            }
            case BOOL: {
                return this.decodeBOOL(inserter, meta);
            }
            case LONG: {
                return this.decodeLONG(inserter, meta);
            }
            case DOUBLE: {
                return this.decodeDOUBLE(inserter, meta);
            }
            case STRING: {
                return this.decodeSTRING(inserter, meta);
            }
            case DATA: {
                return this.decodeDATA(inserter, meta);
            }
            case ARRAY: {
                return this.decodeARRAY(inserter, meta);
            }
            case OBJECT: {
                return this.decodeOBJECT(inserter, meta);
            }
        }
        assert (false) : "should not be reached";
        return null;
    }

    void decodeValue(Inserter inserter) {
        byte b = this.in.getByte();
        Cursor cursor = this.decodeValue(inserter, BinaryFormat.decode_type(b), BinaryFormat.decode_meta(b));
        if (!cursor.valid()) {
            this.in.fail("failed to decode value");
        }
    }

    static void decodeSymbolTable(BufferedInput input, SymbolTable names) {
        int numSymbols = input.read_cmpr_int();
        byte[] backing = input.getBacking();
        for (int i = 0; i < numSymbols; ++i) {
            int size = input.read_cmpr_int();
            int offset = input.getPosition();
            input.skip(size);
            int symbol = names.insert(Utf8Codec.decode(backing, offset, size));
            if (symbol == i) continue;
            input.fail("duplicate symbols in symbol table");
            return;
        }
    }
}

