/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.text;

import java.util.Objects;

public class UnicodeString {
    private final String s;

    public UnicodeString(String s) {
        this.s = Objects.requireNonNull(s);
    }

    public UnicodeString substring(int start, int codePoints) {
        int cps = codePoints * 2 <= this.s.length() - start ? codePoints : Math.min(codePoints, this.s.codePointCount(start, this.s.length()));
        return new UnicodeString(this.s.substring(start, this.s.offsetByCodePoints(start, cps)));
    }

    public int skip(int codePointCount, int start) {
        int index = start;
        for (int i = 0; i < codePointCount && (index = this.nextIndex(index)) <= this.s.length(); ++i) {
        }
        return index;
    }

    public int nextIndex(int index) {
        int next = index + 1;
        if (next < this.s.length() && Character.isLowSurrogate(this.s.charAt(next))) {
            ++next;
        }
        return next;
    }

    public int nextCodePoint(int index) {
        int next = this.nextIndex(index);
        return next >= this.s.length() ? 0 : this.s.codePointAt(next);
    }

    public int length() {
        return this.s.length();
    }

    public int codePointCount() {
        return this.s.codePointCount(0, this.s.length());
    }

    public int codePointAt(int index) {
        return this.s.codePointAt(index);
    }

    public String toString() {
        return this.s;
    }

    public boolean equals(Object o) {
        if (!(o instanceof UnicodeString)) {
            return false;
        }
        UnicodeString other = (UnicodeString)o;
        return this.s.equals(other.s);
    }

    public int hashCode() {
        return this.s.hashCode();
    }
}

