/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.yolean.concurrent;

import com.yahoo.api.annotations.Beta;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

@Beta
public class Memoized<T, E extends Exception>
implements Supplier<T>,
AutoCloseable {
    private final Object monitor = new Object();
    private final Closer<T, E> closer;
    private volatile T wrapped;
    private Supplier<T> factory;

    public Memoized(Supplier<T> factory, Closer<T, E> closer) {
        this.factory = Objects.requireNonNull(factory);
        this.closer = Objects.requireNonNull(closer);
    }

    public static <T extends AutoCloseable> Memoized<T, ?> of(Supplier<T> factory) {
        return new Memoized(factory, AutoCloseable::close);
    }

    public static <T, U, E extends Exception> Memoized<U, E> combine(Memoized<T, ? extends E> inner, Function<T, U> outer, Closer<U, ? extends E> closer) {
        return new Memoized<Object, E>(() -> outer.apply(inner.get()), Memoized.compose(closer, inner::close));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (this.wrapped == null) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.factory != null) {
                    this.wrapped = Objects.requireNonNull(this.factory.get());
                }
                this.factory = null;
                if (this.wrapped == null) {
                    throw new IllegalStateException("already closed");
                }
            }
        }
        return this.wrapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws E {
        Object object = this.monitor;
        synchronized (object) {
            T maybe = this.wrapped;
            this.wrapped = null;
            this.factory = null;
            if (maybe != null) {
                this.closer.close(maybe);
            }
        }
    }

    private static <T, E extends Exception> Closer<T, E> compose(Closer<T, ? extends E> outer, Thrower<? extends E> inner) {
        return parent -> {
            Exception thrown = null;
            try {
                outer.close(parent);
            }
            catch (Exception e) {
                thrown = e;
            }
            try {
                inner.call();
            }
            catch (Exception e) {
                if (thrown != null) {
                    thrown.addSuppressed(e);
                }
                thrown = e;
            }
            Exception e = thrown;
            if (e != null) {
                throw e;
            }
        };
    }

    @FunctionalInterface
    public static interface Closer<T, E extends Exception> {
        public void close(T var1) throws E;
    }

    private static interface Thrower<E extends Exception> {
        public void call() throws E;
    }
}

