/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.yahoo.tensor.DimensionSizes;
import com.yahoo.tensor.IndexedDoubleTensor;
import com.yahoo.tensor.IndexedFloatTensor;
import com.yahoo.tensor.PartialAddress;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;

public abstract class IndexedTensor
implements Tensor {
    private final TensorType type;
    private final DimensionSizes dimensionSizes;

    IndexedTensor(TensorType type, DimensionSizes dimensionSizes) {
        this.type = type;
        this.dimensionSizes = dimensionSizes;
    }

    @Override
    public Iterator<Tensor.Cell> cellIterator() {
        return new CellIterator();
    }

    public SubspaceIterator cellIterator(PartialAddress partialAddress, DimensionSizes iterationSizes) {
        long[] startAddress = new long[this.type().dimensions().size()];
        ArrayList<Integer> iterateDimensions = new ArrayList<Integer>();
        for (int i = 0; i < this.type().dimensions().size(); ++i) {
            long partialAddressLabel = partialAddress.numericLabel(this.type.dimensions().get(i).name());
            if (partialAddressLabel >= 0L) {
                startAddress[i] = partialAddressLabel;
                continue;
            }
            iterateDimensions.add(i);
        }
        return new SubspaceIterator(iterateDimensions, startAddress, iterationSizes);
    }

    @Override
    public Iterator<Double> valueIterator() {
        return new ValueIterator();
    }

    public Iterator<SubspaceIterator> subspaceIterator(Set<String> dimensions, DimensionSizes sizes) {
        return new SuperspaceIterator(dimensions, sizes);
    }

    public Iterator<SubspaceIterator> subspaceIterator(Set<String> dimensions) {
        return this.subspaceIterator(dimensions, this.dimensionSizes);
    }

    public double get(long ... indexes) {
        return this.get((long)((int)IndexedTensor.toValueIndex(indexes, this.dimensionSizes)));
    }

    public float getFloat(long ... indexes) {
        return this.getFloat((long)((int)IndexedTensor.toValueIndex(indexes, this.dimensionSizes)));
    }

    @Override
    public double get(TensorAddress address) {
        try {
            return this.get((long)((int)IndexedTensor.toValueIndex(address, this.dimensionSizes, this.type)));
        }
        catch (IllegalArgumentException e) {
            return 0.0;
        }
    }

    @Override
    public boolean has(TensorAddress address) {
        try {
            long index = IndexedTensor.toValueIndex(address, this.dimensionSizes, this.type);
            if (index < 0L) {
                return false;
            }
            return index < this.size();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public abstract double get(long var1);

    public abstract float getFloat(long var1);

    static long toValueIndex(long[] indexes, DimensionSizes sizes) {
        if (indexes.length == 1) {
            return indexes[0];
        }
        if (indexes.length == 0) {
            return 0L;
        }
        long valueIndex = 0L;
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] >= sizes.size(i)) {
                throw new IllegalArgumentException(Arrays.toString(indexes) + " are not within bounds");
            }
            valueIndex += IndexedTensor.productOfDimensionsAfter(i, sizes) * indexes[i];
        }
        return valueIndex;
    }

    static long toValueIndex(TensorAddress address, DimensionSizes sizes, TensorType type) {
        if (address.isEmpty()) {
            return 0L;
        }
        long valueIndex = 0L;
        for (int i = 0; i < address.size(); ++i) {
            if (address.numericLabel(i) >= sizes.size(i)) {
                throw new IllegalArgumentException(address + " is not within the bounds of " + type);
            }
            valueIndex += IndexedTensor.productOfDimensionsAfter(i, sizes) * address.numericLabel(i);
        }
        return valueIndex;
    }

    private static long productOfDimensionsAfter(int afterIndex, DimensionSizes sizes) {
        long product = 1L;
        for (int i = afterIndex + 1; i < sizes.dimensions(); ++i) {
            product *= sizes.size(i);
        }
        return product;
    }

    void throwOnIncompatibleType(TensorType type) {
        if (!this.type().isRenamableTo(type)) {
            throw new IllegalArgumentException("Can not change type from " + this.type() + " to " + type + ": Types are not compatible");
        }
    }

    @Override
    public TensorType type() {
        return this.type;
    }

    @Override
    public abstract IndexedTensor withType(TensorType var1);

    public DimensionSizes dimensionSizes() {
        return this.dimensionSizes;
    }

    public long[] shape() {
        long[] result = new long[this.dimensionSizes.dimensions()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.dimensionSizes.size(i);
        }
        return result;
    }

    @Override
    public Map<TensorAddress, Double> cells() {
        if (this.dimensionSizes.dimensions() == 0) {
            return Collections.singletonMap(TensorAddress.of(new long[0]), this.get(0L));
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        Indexes indexes = Indexes.of(this.dimensionSizes, this.dimensionSizes, this.size());
        for (long i = 0L; i < this.size(); ++i) {
            indexes.next();
            builder.put((Object)indexes.toAddress(), (Object)this.get(i));
        }
        return builder.build();
    }

    @Override
    public Tensor remove(Set<TensorAddress> addresses) {
        throw new IllegalArgumentException("Remove is not supported for indexed tensors");
    }

    @Override
    public String toString() {
        return this.toString(true, true);
    }

    @Override
    public String toString(boolean withType, boolean shortForms) {
        return this.toString(withType, shortForms, Long.MAX_VALUE);
    }

    @Override
    public String toAbbreviatedString() {
        return this.toString(true, true, Math.max(2L, 10L / (this.type().dimensions().stream().filter(d -> d.isMapped()).count() + 1L)));
    }

    private String toString(boolean withType, boolean shortForms, long maxCells) {
        if (!shortForms || this.type.rank() == 0 || this.type.dimensions().stream().anyMatch(d -> d.size().isEmpty())) {
            return Tensor.toStandardString(this, withType, shortForms, maxCells);
        }
        Indexes indexes = Indexes.of(this.dimensionSizes);
        StringBuilder b = new StringBuilder();
        if (withType) {
            b.append(this.type).append(":");
        }
        IndexedTensor.indexedBlockToString(this, indexes, maxCells, b);
        return b.toString();
    }

    static void indexedBlockToString(IndexedTensor tensor, Indexes indexes, long maxCells, StringBuilder b) {
        int index = 0;
        while ((long)index < tensor.size() && (long)index < maxCells) {
            int i;
            indexes.next();
            if (index > 0) {
                b.append(", ");
            }
            for (i = 0; i < indexes.nextDimensionsAtStart(); ++i) {
                b.append("[");
            }
            switch (tensor.type().valueType()) {
                case DOUBLE: {
                    b.append(tensor.get((long)index));
                    break;
                }
                case FLOAT: {
                    b.append(tensor.getFloat((long)index));
                    break;
                }
                case BFLOAT16: {
                    b.append(tensor.getFloat((long)index));
                    break;
                }
                case INT8: {
                    b.append((byte)tensor.getFloat((long)index));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value type " + tensor.type().valueType());
                }
            }
            for (i = 0; i < indexes.nextDimensionsAtEnd(); ++i) {
                b.append("]");
            }
            ++index;
        }
        if ((long)index == maxCells && (long)index < tensor.size()) {
            b.append(", ...]");
        }
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Tensor)) {
            return false;
        }
        return Tensor.equals(this, (Tensor)other);
    }

    private final class CellIterator
    implements Iterator<Tensor.Cell> {
        private long count = 0L;
        private final Indexes indexes;
        private final LazyCell reusedCell;

        private CellIterator() {
            this.indexes = Indexes.of(IndexedTensor.this.dimensionSizes, IndexedTensor.this.dimensionSizes, IndexedTensor.this.size());
            this.reusedCell = new LazyCell(this.indexes, Double.NaN);
        }

        @Override
        public boolean hasNext() {
            return this.count < this.indexes.size();
        }

        @Override
        public Tensor.Cell next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No cell at " + this.indexes);
            }
            ++this.count;
            this.indexes.next();
            this.reusedCell.value = IndexedTensor.this.get(this.indexes.toSourceValueIndex());
            return this.reusedCell;
        }
    }

    public final class SubspaceIterator
    implements Iterator<Tensor.Cell> {
        private final List<Integer> iterateDimensions;
        private final long[] address;
        private final DimensionSizes iterateSizes;
        private Indexes indexes;
        private long count = 0L;
        private final LazyCell reusedCell;

        private SubspaceIterator(List<Integer> iterateDimensions, long[] address, DimensionSizes iterateSizes) {
            this.iterateDimensions = iterateDimensions;
            this.address = address;
            this.iterateSizes = iterateSizes;
            this.indexes = Indexes.of(IndexedTensor.this.dimensionSizes, iterateSizes, iterateDimensions, address);
            this.reusedCell = new LazyCell(this.indexes, Double.NaN);
        }

        public long size() {
            return this.indexes.size();
        }

        public TensorAddress address() {
            return this.indexes.toAddress();
        }

        public void reset() {
            this.count = 0L;
            this.indexes = Indexes.of(IndexedTensor.this.dimensionSizes, this.iterateSizes, this.iterateDimensions, this.address);
        }

        @Override
        public boolean hasNext() {
            return this.count < this.indexes.size();
        }

        @Override
        public Tensor.Cell next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No cell at " + this.indexes);
            }
            ++this.count;
            this.indexes.next();
            this.reusedCell.value = IndexedTensor.this.get(this.indexes.toSourceValueIndex());
            return this.reusedCell;
        }
    }

    private final class ValueIterator
    implements Iterator<Double> {
        private long count = 0L;

        private ValueIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < IndexedTensor.this.size();
        }

        @Override
        public Double next() {
            try {
                return IndexedTensor.this.get(this.count++);
            }
            catch (IllegalArgumentException e) {
                throw new NoSuchElementException("No element at position " + this.count);
            }
        }
    }

    private final class SuperspaceIterator
    implements Iterator<SubspaceIterator> {
        private final Indexes superindexes;
        private final List<Integer> subdimensionIndexes;
        private final DimensionSizes iterateSizes;
        private long count = 0L;

        private SuperspaceIterator(Set<String> superdimensionNames, DimensionSizes iterateSizes) {
            this.iterateSizes = iterateSizes;
            ArrayList<Integer> superdimensionIndexes = new ArrayList<Integer>(superdimensionNames.size());
            this.subdimensionIndexes = new ArrayList<Integer>(superdimensionNames.size());
            for (int i = IndexedTensor.this.type.dimensions().size() - 1; i >= 0; --i) {
                if (superdimensionNames.contains(IndexedTensor.this.type.dimensions().get(i).name())) {
                    superdimensionIndexes.add(i);
                    continue;
                }
                this.subdimensionIndexes.add(i);
            }
            this.superindexes = Indexes.of(IndexedTensor.this.dimensionSizes, iterateSizes, superdimensionIndexes);
        }

        @Override
        public boolean hasNext() {
            return this.count < this.superindexes.size();
        }

        @Override
        public SubspaceIterator next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No cell at " + this.superindexes);
            }
            ++this.count;
            this.superindexes.next();
            return new SubspaceIterator(this.subdimensionIndexes, this.superindexes.indexesCopy(), this.iterateSizes);
        }
    }

    public static abstract class Indexes {
        private final DimensionSizes sourceSizes;
        private final DimensionSizes iterationSizes;
        protected final long[] indexes;

        public static Indexes of(TensorType type) {
            return Indexes.of(DimensionSizes.of(type));
        }

        public static Indexes of(TensorType type, List<String> iterateDimensionOrder) {
            return Indexes.of(DimensionSizes.of(type), Indexes.toIterationOrder(iterateDimensionOrder, type));
        }

        public static Indexes of(DimensionSizes sizes) {
            return Indexes.of(sizes, sizes);
        }

        private static Indexes of(DimensionSizes sourceSizes, DimensionSizes iterateSizes) {
            return Indexes.of(sourceSizes, iterateSizes, Indexes.completeIterationOrder(iterateSizes.dimensions()));
        }

        private static Indexes of(DimensionSizes sourceSizes, DimensionSizes iterateSizes, long size) {
            return Indexes.of(sourceSizes, iterateSizes, Indexes.completeIterationOrder(iterateSizes.dimensions()), size);
        }

        private static Indexes of(DimensionSizes sizes, List<Integer> iterateDimensions) {
            return Indexes.of(sizes, sizes, iterateDimensions);
        }

        private static Indexes of(DimensionSizes sourceSizes, DimensionSizes iterateSizes, List<Integer> iterateDimensions) {
            return Indexes.of(sourceSizes, iterateSizes, iterateDimensions, Indexes.computeSize(iterateSizes, iterateDimensions));
        }

        private static Indexes of(DimensionSizes sourceSizes, DimensionSizes iterateSizes, List<Integer> iterateDimensions, long size) {
            return Indexes.of(sourceSizes, iterateSizes, iterateDimensions, new long[iterateSizes.dimensions()], size);
        }

        private static Indexes of(DimensionSizes sourceSizes, DimensionSizes iterateSizes, List<Integer> iterateDimensions, long[] initialIndexes) {
            return Indexes.of(sourceSizes, iterateSizes, iterateDimensions, initialIndexes, Indexes.computeSize(iterateSizes, iterateDimensions));
        }

        private static Indexes of(DimensionSizes sourceSizes, DimensionSizes iterateSizes, List<Integer> iterateDimensions, long[] initialIndexes, long size) {
            if (size == 0L) {
                return new EmptyIndexes(sourceSizes, iterateSizes, initialIndexes);
            }
            if (size == 1L) {
                return new SingleValueIndexes(sourceSizes, iterateSizes, initialIndexes);
            }
            if (iterateDimensions.size() == 1) {
                if (sourceSizes.equals(iterateSizes)) {
                    return new EqualSizeSingleDimensionIndexes(sourceSizes, iterateDimensions.get(0), initialIndexes, size);
                }
                return new SingleDimensionIndexes(sourceSizes, iterateSizes, iterateDimensions.get(0), initialIndexes, size);
            }
            if (sourceSizes.equals(iterateSizes)) {
                return new EqualSizeMultiDimensionIndexes(sourceSizes, iterateDimensions, initialIndexes, size);
            }
            return new MultiDimensionIndexes(sourceSizes, iterateSizes, iterateDimensions, initialIndexes, size);
        }

        private static List<Integer> toIterationOrder(List<String> dimensionNames, TensorType type) {
            if (dimensionNames == null) {
                return Indexes.completeIterationOrder(type.rank());
            }
            ArrayList<Integer> iterationDimensions = new ArrayList<Integer>(type.rank());
            for (int i = 0; i < type.rank(); ++i) {
                iterationDimensions.add(type.rank() - 1 - type.indexOfDimension(dimensionNames.get(i)).get());
            }
            return iterationDimensions;
        }

        private static List<Integer> completeIterationOrder(int length) {
            ArrayList<Integer> iterationDimensions = new ArrayList<Integer>(length);
            for (int i = 0; i < length; ++i) {
                iterationDimensions.add(length - 1 - i);
            }
            return iterationDimensions;
        }

        private Indexes(DimensionSizes sourceSizes, DimensionSizes iterationSizes, long[] indexes) {
            this.sourceSizes = sourceSizes;
            this.iterationSizes = iterationSizes;
            this.indexes = indexes;
        }

        private static long computeSize(DimensionSizes sizes, List<Integer> iterateDimensions) {
            long size = 1L;
            for (int iterateDimension : iterateDimensions) {
                size *= sizes.size(iterateDimension);
            }
            return size;
        }

        public TensorAddress toAddress() {
            return TensorAddress.of(this.indexes);
        }

        public long[] indexesCopy() {
            return Arrays.copyOf(this.indexes, this.indexes.length);
        }

        public long[] indexesForReading() {
            return this.indexes;
        }

        public long toSourceValueIndex() {
            return IndexedTensor.toValueIndex(this.indexes, this.sourceSizes);
        }

        long toIterationValueIndex() {
            return IndexedTensor.toValueIndex(this.indexes, this.iterationSizes);
        }

        DimensionSizes dimensionSizes() {
            return this.iterationSizes;
        }

        public List<Long> toList() {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (long index : this.indexes) {
                builder.add((Object)index);
            }
            return builder.build();
        }

        public String toString() {
            return "indexes " + Arrays.toString(this.indexes);
        }

        public abstract long size();

        public abstract void next();

        public abstract boolean hasNext();

        abstract int nextDimensionsAtStart();

        abstract int nextDimensionsAtEnd();
    }

    private static final class EqualSizeSingleDimensionIndexes
    extends Indexes {
        private final long size;
        private final int iterateDimension;
        private long currentValueIndex;
        private final long step;

        private EqualSizeSingleDimensionIndexes(DimensionSizes sizes, int iterateDimension, long[] initialIndexes, long size) {
            super(sizes, sizes, initialIndexes);
            this.iterateDimension = iterateDimension;
            this.size = size;
            this.step = IndexedTensor.productOfDimensionsAfter(iterateDimension, sizes);
            int n = iterateDimension;
            this.indexes[n] = this.indexes[n] - 1L;
            this.currentValueIndex = IndexedTensor.toValueIndex(this.indexes, sizes);
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public void next() {
            int n = this.iterateDimension;
            this.indexes[n] = this.indexes[n] + 1L;
            this.currentValueIndex += this.step;
        }

        @Override
        public boolean hasNext() {
            return this.indexes[this.iterateDimension] + 1L < this.size;
        }

        @Override
        public long toSourceValueIndex() {
            return this.currentValueIndex;
        }

        @Override
        long toIterationValueIndex() {
            return this.currentValueIndex;
        }

        @Override
        int nextDimensionsAtStart() {
            return this.currentValueIndex == 0L ? 1 : 0;
        }

        @Override
        int nextDimensionsAtEnd() {
            return this.currentValueIndex == this.size - 1L ? 1 : 0;
        }
    }

    private static final class SingleDimensionIndexes
    extends Indexes {
        private final long size;
        private final int iterateDimension;
        private long currentSourceValueIndex;
        private long currentIterationValueIndex;
        private final long sourceStep;
        private final long iterationStep;

        private SingleDimensionIndexes(DimensionSizes sourceSizes, DimensionSizes iterateSizes, int iterateDimension, long[] initialIndexes, long size) {
            super(sourceSizes, iterateSizes, initialIndexes);
            this.iterateDimension = iterateDimension;
            this.size = size;
            this.sourceStep = IndexedTensor.productOfDimensionsAfter(iterateDimension, sourceSizes);
            this.iterationStep = IndexedTensor.productOfDimensionsAfter(iterateDimension, iterateSizes);
            int n = iterateDimension;
            this.indexes[n] = this.indexes[n] - 1L;
            this.currentSourceValueIndex = IndexedTensor.toValueIndex(this.indexes, sourceSizes);
            this.currentIterationValueIndex = IndexedTensor.toValueIndex(this.indexes, iterateSizes);
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public void next() {
            int n = this.iterateDimension;
            this.indexes[n] = this.indexes[n] + 1L;
            this.currentSourceValueIndex += this.sourceStep;
            this.currentIterationValueIndex += this.iterationStep;
        }

        @Override
        public long toSourceValueIndex() {
            return this.currentSourceValueIndex;
        }

        @Override
        long toIterationValueIndex() {
            return this.currentIterationValueIndex;
        }

        @Override
        public boolean hasNext() {
            return this.indexes[this.iterateDimension] + 1L < this.size;
        }

        @Override
        int nextDimensionsAtStart() {
            return this.currentSourceValueIndex == 0L ? 1 : 0;
        }

        @Override
        int nextDimensionsAtEnd() {
            return this.currentSourceValueIndex == this.size - 1L ? 1 : 0;
        }
    }

    private static final class EqualSizeMultiDimensionIndexes
    extends MultiDimensionIndexes {
        private long lastComputedSourceValueIndex = -1L;

        private EqualSizeMultiDimensionIndexes(DimensionSizes sizes, List<Integer> iterateDimensions, long[] initialIndexes, long size) {
            super(sizes, sizes, iterateDimensions, initialIndexes, size);
        }

        @Override
        public long toSourceValueIndex() {
            this.lastComputedSourceValueIndex = super.toSourceValueIndex();
            return this.lastComputedSourceValueIndex;
        }

        @Override
        long toIterationValueIndex() {
            return this.lastComputedSourceValueIndex;
        }
    }

    private static class MultiDimensionIndexes
    extends Indexes {
        private final long size;
        private final List<Integer> iterateDimensions;

        private MultiDimensionIndexes(DimensionSizes sourceSizes, DimensionSizes iterateSizes, List<Integer> iterateDimensions, long[] initialIndexes, long size) {
            super(sourceSizes, iterateSizes, initialIndexes);
            this.iterateDimensions = iterateDimensions;
            this.size = size;
            int n = iterateDimensions.get(0);
            this.indexes[n] = this.indexes[n] - 1L;
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public void next() {
            int iterateDimensionsIndex = 0;
            while (this.indexes[this.iterateDimensions.get(iterateDimensionsIndex)] + 1L == this.dimensionSizes().size(this.iterateDimensions.get(iterateDimensionsIndex))) {
                this.indexes[this.iterateDimensions.get((int)iterateDimensionsIndex).intValue()] = 0L;
                ++iterateDimensionsIndex;
            }
            int n = this.iterateDimensions.get(iterateDimensionsIndex);
            this.indexes[n] = this.indexes[n] + 1L;
        }

        @Override
        public boolean hasNext() {
            for (int iterateDimension : this.iterateDimensions) {
                if (this.indexes[iterateDimension] + 1L >= this.dimensionSizes().size(iterateDimension)) continue;
                return true;
            }
            return false;
        }

        @Override
        int nextDimensionsAtStart() {
            int dimension;
            for (dimension = 0; dimension < this.iterateDimensions.size() && this.indexes[this.iterateDimensions.get(dimension)] == 0L; ++dimension) {
            }
            return dimension;
        }

        @Override
        int nextDimensionsAtEnd() {
            int dimension;
            for (dimension = 0; dimension < this.iterateDimensions.size() && this.indexes[this.iterateDimensions.get(dimension)] == this.dimensionSizes().size(this.iterateDimensions.get(dimension)) - 1L; ++dimension) {
            }
            return dimension;
        }
    }

    private static final class SingleValueIndexes
    extends Indexes {
        private boolean exhausted = false;

        private SingleValueIndexes(DimensionSizes sourceSizes, DimensionSizes iterateSizes, long[] indexes) {
            super(sourceSizes, iterateSizes, indexes);
        }

        @Override
        public long size() {
            return 1L;
        }

        @Override
        public void next() {
            this.exhausted = true;
        }

        @Override
        public boolean hasNext() {
            return !this.exhausted;
        }

        @Override
        int nextDimensionsAtStart() {
            return 1;
        }

        @Override
        int nextDimensionsAtEnd() {
            return 1;
        }
    }

    private static final class EmptyIndexes
    extends Indexes {
        private EmptyIndexes(DimensionSizes sourceSizes, DimensionSizes iterateSizes, long[] indexes) {
            super(sourceSizes, iterateSizes, indexes);
        }

        @Override
        public long size() {
            return 0L;
        }

        @Override
        public void next() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        int nextDimensionsAtStart() {
            return 0;
        }

        @Override
        int nextDimensionsAtEnd() {
            return 0;
        }
    }

    private static final class LazyCell
    extends Tensor.Cell {
        private double value;
        private Indexes indexes;

        private LazyCell(Indexes indexes, Double value) {
            super(null, value);
            this.indexes = indexes;
        }

        @Override
        long getDirectIndex() {
            return this.indexes.toIterationValueIndex();
        }

        @Override
        public TensorAddress getKey() {
            return this.indexes.toAddress();
        }

        @Override
        public Double getValue() {
            return this.value;
        }

        @Override
        public Tensor.Cell detach() {
            return new Tensor.Cell(this.getKey(), this.value);
        }
    }

    private static class UnboundBuilder
    extends Builder {
        private List<Object> firstDimension = null;

        private UnboundBuilder(TensorType type) {
            super(type);
        }

        @Override
        public IndexedTensor build() {
            if (this.firstDimension == null) {
                throw new IllegalArgumentException("Tensor of type " + this.type() + " has no values");
            }
            if (this.type.dimensions().isEmpty()) {
                return new IndexedDoubleTensor(this.type, new DimensionSizes.Builder(this.type.dimensions().size()).build(), new double[]{(Double)this.firstDimension.get(0)});
            }
            DimensionSizes dimensionSizes = this.findDimensionSizes(this.firstDimension);
            double[] values = new double[(int)dimensionSizes.totalSize()];
            this.fillValues(0, 0L, this.firstDimension, dimensionSizes, values);
            return new IndexedDoubleTensor(this.type, dimensionSizes, values);
        }

        private DimensionSizes findDimensionSizes(List<Object> firstDimension) {
            ArrayList<Long> dimensionSizeList = new ArrayList<Long>(this.type.dimensions().size());
            this.findDimensionSizes(0, dimensionSizeList, firstDimension);
            DimensionSizes.Builder b = new DimensionSizes.Builder(this.type.dimensions().size());
            for (int i = 0; i < b.dimensions(); ++i) {
                if (i >= dimensionSizeList.size()) continue;
                b.set(i, (Long)dimensionSizeList.get(i));
            }
            return b.build();
        }

        private void findDimensionSizes(int currentDimensionIndex, List<Long> dimensionSizes, List<Object> currentDimension) {
            if (currentDimensionIndex == dimensionSizes.size()) {
                dimensionSizes.add(Long.valueOf(currentDimension.size()));
            } else if (dimensionSizes.get(currentDimensionIndex) != (long)currentDimension.size()) {
                throw new IllegalArgumentException("Missing values in dimension " + this.type.dimensions().get(currentDimensionIndex) + " in " + this.type);
            }
            for (Object value : currentDimension) {
                if (!(value instanceof List)) continue;
                this.findDimensionSizes(currentDimensionIndex + 1, dimensionSizes, (List)value);
            }
        }

        private void fillValues(int currentDimensionIndex, long offset, List<Object> currentDimension, DimensionSizes sizes, double[] values) {
            if (currentDimensionIndex < sizes.dimensions() - 1) {
                for (long i = 0L; i < (long)currentDimension.size(); ++i) {
                    this.fillValues(currentDimensionIndex + 1, offset + IndexedTensor.productOfDimensionsAfter(currentDimensionIndex, sizes) * i, (List)currentDimension.get((int)i), sizes, values);
                }
            } else {
                for (long i = 0L; i < (long)currentDimension.size(); ++i) {
                    values[(int)(offset + i)] = this.nullAsZero((Double)currentDimension.get((int)i));
                }
            }
        }

        private double nullAsZero(Double value) {
            if (value == null) {
                return 0.0;
            }
            return value;
        }

        @Override
        public Tensor.Builder.CellBuilder cell() {
            return new Tensor.Builder.CellBuilder(this.type, this);
        }

        @Override
        public Builder cell(TensorAddress address, float value) {
            return this.cell(address, (double)value);
        }

        @Override
        public Builder cell(TensorAddress address, double value) {
            long[] indexes = new long[address.size()];
            for (int i = 0; i < address.size(); ++i) {
                indexes[i] = address.numericLabel(i);
            }
            this.cell(value, indexes);
            return this;
        }

        @Override
        public Builder cell(float value, long ... indexes) {
            return this.cell((double)value, indexes);
        }

        @Override
        public Builder cell(double value, long ... indexes) {
            if (indexes.length != this.type.dimensions().size()) {
                throw new IllegalArgumentException("Wrong number of indexes (" + indexes.length + ") for " + this.type);
            }
            if (indexes.length == 0) {
                this.firstDimension = Collections.singletonList(value);
                return this;
            }
            if (this.firstDimension == null) {
                this.firstDimension = new ArrayList<Object>();
            }
            List currentValues = this.firstDimension;
            for (int dimensionIndex = 0; dimensionIndex < indexes.length; ++dimensionIndex) {
                this.ensureCapacity(indexes[dimensionIndex], currentValues);
                if (dimensionIndex == indexes.length - 1) {
                    currentValues.set((int)indexes[dimensionIndex], value);
                    continue;
                }
                if (currentValues.get((int)indexes[dimensionIndex]) == null) {
                    currentValues.set((int)indexes[dimensionIndex], new ArrayList());
                }
                currentValues = (List)currentValues.get((int)indexes[dimensionIndex]);
            }
            return this;
        }

        private void ensureCapacity(long index, List<Object> list) {
            while ((long)list.size() <= index) {
                list.add(list.size(), null);
            }
        }
    }

    public static abstract class BoundBuilder
    extends Builder
    implements DirectIndexBuilder {
        private final DimensionSizes sizes;

        private static DimensionSizes dimensionSizesOf(TensorType type) {
            DimensionSizes.Builder b = new DimensionSizes.Builder(type.dimensions().size());
            for (int i = 0; i < type.dimensions().size(); ++i) {
                b.set(i, type.dimensions().get(i).size().get());
            }
            return b.build();
        }

        BoundBuilder(TensorType type, DimensionSizes sizes) {
            super(type);
            if (sizes.dimensions() != type.dimensions().size()) {
                throw new IllegalArgumentException("Must have a dimension size entry for each dimension in " + type);
            }
            this.sizes = sizes;
        }

        public BoundBuilder fill(float[] values) {
            long index = 0L;
            for (float value : values) {
                this.cellByDirectIndex(index++, value);
            }
            return this;
        }

        public BoundBuilder fill(double[] values) {
            long index = 0L;
            for (double value : values) {
                this.cellByDirectIndex(index++, value);
            }
            return this;
        }

        DimensionSizes sizes() {
            return this.sizes;
        }
    }

    public static interface DirectIndexBuilder {
        public TensorType type();

        public void cellByDirectIndex(long var1, double var3);

        public void cellByDirectIndex(long var1, float var3);
    }

    public static abstract class Builder
    implements Tensor.Builder {
        final TensorType type;

        private Builder(TensorType type) {
            this.type = type;
        }

        public static Builder of(TensorType type) {
            if (type.dimensions().stream().allMatch(d -> d instanceof TensorType.IndexedBoundDimension)) {
                return Builder.of(type, BoundBuilder.dimensionSizesOf(type));
            }
            return new UnboundBuilder(type);
        }

        public static Builder of(TensorType type, float[] values) {
            if (type.dimensions().stream().allMatch(d -> d instanceof TensorType.IndexedBoundDimension)) {
                return Builder.of(type, BoundBuilder.dimensionSizesOf(type), values);
            }
            return new UnboundBuilder(type);
        }

        public static Builder of(TensorType type, double[] values) {
            if (type.dimensions().stream().allMatch(d -> d instanceof TensorType.IndexedBoundDimension)) {
                return Builder.of(type, BoundBuilder.dimensionSizesOf(type), values);
            }
            return new UnboundBuilder(type);
        }

        public static Builder of(TensorType type, DimensionSizes sizes) {
            Builder.validate(type, sizes);
            switch (type.valueType()) {
                case DOUBLE: {
                    return new IndexedDoubleTensor.BoundDoubleBuilder(type, sizes);
                }
                case FLOAT: {
                    return new IndexedFloatTensor.BoundFloatBuilder(type, sizes);
                }
                case BFLOAT16: {
                    return new IndexedFloatTensor.BoundFloatBuilder(type, sizes);
                }
                case INT8: {
                    return new IndexedFloatTensor.BoundFloatBuilder(type, sizes);
                }
            }
            throw new IllegalStateException("Unexpected value type " + type.valueType());
        }

        public static Builder of(TensorType type, DimensionSizes sizes, float[] values) {
            Builder.validate(type, sizes);
            Builder.validateSizes(sizes, values.length);
            switch (type.valueType()) {
                case DOUBLE: {
                    return new IndexedDoubleTensor.BoundDoubleBuilder(type, sizes).fill(values);
                }
                case FLOAT: {
                    return new IndexedFloatTensor.BoundFloatBuilder(type, sizes, values);
                }
                case BFLOAT16: {
                    return new IndexedFloatTensor.BoundFloatBuilder(type, sizes, values);
                }
                case INT8: {
                    return new IndexedFloatTensor.BoundFloatBuilder(type, sizes, values);
                }
            }
            throw new IllegalStateException("Unexpected value type " + type.valueType());
        }

        public static Builder of(TensorType type, DimensionSizes sizes, double[] values) {
            Builder.validate(type, sizes);
            Builder.validateSizes(sizes, values.length);
            switch (type.valueType()) {
                case DOUBLE: {
                    return new IndexedDoubleTensor.BoundDoubleBuilder(type, sizes, values);
                }
                case FLOAT: {
                    return new IndexedFloatTensor.BoundFloatBuilder(type, sizes).fill(values);
                }
                case BFLOAT16: {
                    return new IndexedFloatTensor.BoundFloatBuilder(type, sizes).fill(values);
                }
                case INT8: {
                    return new IndexedFloatTensor.BoundFloatBuilder(type, sizes).fill(values);
                }
            }
            throw new IllegalStateException("Unexpected value type " + type.valueType());
        }

        private static void validateSizes(DimensionSizes sizes, int length) {
            if (sizes.totalSize() != (long)length) {
                throw new IllegalArgumentException("Invalid size(" + length + ") of supplied value vector. Type specifies that size should be " + sizes.totalSize());
            }
        }

        private static void validate(TensorType type, DimensionSizes sizes) {
            if (sizes.dimensions() != type.dimensions().size()) {
                throw new IllegalArgumentException(sizes.dimensions() + " is the wrong number of dimensions for " + type);
            }
            for (int i = 0; i < sizes.dimensions(); ++i) {
                Optional<Long> size = type.dimensions().get(i).size();
                if (!size.isPresent() || size.get() >= sizes.size(i)) continue;
                throw new IllegalArgumentException("Size of dimension " + type.dimensions().get(i).name() + " is " + sizes.size(i) + " but cannot be larger than " + size.get() + " in " + type);
            }
        }

        @Override
        public abstract Builder cell(double var1, long ... var3);

        @Override
        public abstract Builder cell(float var1, long ... var2);

        @Override
        public TensorType type() {
            return this.type;
        }

        @Override
        public abstract IndexedTensor build();
    }
}

