/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CommandLineParser {
    private static final HashSet<String> helpSwitches = new HashSet();
    private final List<String> inputStrings;
    private final Map<String, String> legalUnarySwitches = new HashMap<String, String>();
    private final Map<String, String> legalBinarySwitches = new HashMap<String, String>();
    private final List<String> unarySwitches = new ArrayList<String>();
    private final Map<String, String> binarySwitches = new HashMap<String, String>();
    private final List<String> arguments = new ArrayList<String>();
    private final Map<String, String> requiredUnarySwitches = new HashMap<String, String>();
    private final Map<String, String> requiredBinarySwitches = new HashMap<String, String>();
    private String progname = "progname";
    private String argumentExplanation;
    private int minArguments = 0;
    private int maxArguments = Integer.MAX_VALUE;
    private String helpText;
    private boolean helpSwitchUsed = false;

    public CommandLineParser(String[] cmds) {
        this.inputStrings = Arrays.asList(cmds);
    }

    public CommandLineParser(String progname, String[] cmds) {
        this.progname = progname;
        this.inputStrings = Arrays.asList(cmds);
    }

    public void parse() {
        Iterator<String> it = this.inputStrings.iterator();
        while (it.hasNext()) {
            String i = it.next();
            if (this.isHelpSwitch(i)) {
                this.helpSwitchUsed = true;
                this.usageAndThrow();
            }
            if (i.startsWith("-")) {
                if (!this.isLegalSwitch(i)) {
                    this.usageAndThrow();
                    continue;
                }
                if (this.legalUnarySwitches.keySet().contains(i)) {
                    this.unarySwitches.add(i);
                    continue;
                }
                if (!this.legalBinarySwitches.keySet().contains(i)) continue;
                if (!it.hasNext()) {
                    throw new IllegalArgumentException(i + " requires value");
                }
                String val = it.next();
                this.binarySwitches.put(i, val);
                continue;
            }
            this.arguments.add(i);
        }
        if (!this.requiredUnarySwitches.isEmpty() && !this.getUnarySwitches().containsAll(this.requiredUnarySwitches.keySet())) {
            this.usageAndThrow();
        }
        if (!this.requiredBinarySwitches.isEmpty() && !this.getBinarySwitches().keySet().containsAll(this.requiredBinarySwitches.keySet())) {
            this.usageAndThrow();
        }
        if (this.getArguments().size() < this.minArguments || this.getArguments().size() > this.maxArguments) {
            this.usageAndThrow();
        }
    }

    private boolean isHelpSwitch(String i) {
        return helpSwitches.contains(i);
    }

    void usageAndThrow() {
        StringBuffer error_sb = new StringBuffer();
        error_sb.append("\nusage: ").append(this.progname).append(" ");
        if (this.argumentExplanation != null) {
            error_sb.append(this.argumentExplanation);
        }
        if (!this.legalUnarySwitches.isEmpty()) {
            error_sb.append("\nSwitches:\n");
        }
        error_sb.append("-h This help text\n");
        for (Map.Entry<String, String> e : this.legalUnarySwitches.entrySet()) {
            error_sb.append(e.getKey()).append(" ").append(e.getValue()).append("\n");
        }
        for (Map.Entry<String, String> e : this.legalBinarySwitches.entrySet()) {
            error_sb.append(e.getKey()).append(" <").append(e.getValue()).append(">\n");
        }
        if (this.helpText != null) {
            error_sb.append("\n").append(this.helpText).append("\n");
        }
        throw new IllegalArgumentException(error_sb.toString());
    }

    private boolean isLegalSwitch(String s) {
        return this.legalUnarySwitches.containsKey(s) || this.legalBinarySwitches.containsKey(s);
    }

    public void addLegalUnarySwitch(String s, String explanation) {
        if (this.legalBinarySwitches.containsKey(s)) {
            throw new IllegalArgumentException(s + " already added as a binary switch");
        }
        this.legalUnarySwitches.put(s, explanation);
    }

    public void addLegalUnarySwitch(String s) {
        this.addLegalUnarySwitch(s, null);
    }

    public void addRequiredUnarySwitch(String s, String explanation) {
        this.addLegalUnarySwitch(s, explanation);
        this.requiredUnarySwitches.put(s, explanation);
    }

    public void addLegalBinarySwitch(String s, String explanation) {
        if (this.legalUnarySwitches.containsKey(s)) {
            throw new IllegalArgumentException(s + " already added as a unary switch");
        }
        this.legalBinarySwitches.put(s, explanation);
    }

    public void addLegalBinarySwitch(String s) {
        this.addLegalBinarySwitch(s, null);
    }

    public void addRequiredBinarySwitch(String s, String explanation) {
        this.addLegalBinarySwitch(s, explanation);
        this.requiredBinarySwitches.put(s, explanation);
    }

    public List<String> getUnarySwitches() {
        return this.unarySwitches;
    }

    public Map<String, String> getBinarySwitches() {
        return this.binarySwitches;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public void setArgumentExplanation(String argumentExplanation) {
        this.argumentExplanation = argumentExplanation;
    }

    public void setExtendedHelpText(String text) {
        this.helpText = text;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public void setMinArguments(int minArguments) {
        this.minArguments = minArguments;
    }

    public void setMaxArguments(int maxArguments) {
        this.maxArguments = maxArguments;
    }

    public boolean helpSwitchUsed() {
        return this.helpSwitchUsed;
    }

    static {
        helpSwitches.add("-h");
        helpSwitches.add("-help");
        helpSwitches.add("--help");
        helpSwitches.add("-?");
    }
}

