/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor;

import com.yahoo.api.annotations.Beta;
import com.yahoo.tensor.IndexedTensor;
import com.yahoo.tensor.MixedTensor;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import java.util.Arrays;
import java.util.Iterator;

@Beta
public class Tensors {
    public static Tensor toSparse(Tensor tensor, String ... dimensions) {
        for (String dimension : dimensions) {
            if (!tensor.type().dimension(dimension).isEmpty()) continue;
            throw new IllegalArgumentException("The tensor " + tensor.type() + " is missing the specified dimension '" + dimension + "'");
        }
        if (dimensions.length == 0) {
            dimensions = (String[])tensor.type().dimensions().stream().map(TensorType.Dimension::name).toArray(String[]::new);
        }
        TensorType.Builder targetTypeBuilder = new TensorType.Builder();
        for (TensorType.Dimension sourceDimension : tensor.type().dimensions()) {
            if (sourceDimension.isMapped() || Arrays.stream(dimensions).noneMatch(d -> d.equals(sourceDimension.name()))) {
                targetTypeBuilder.dimension(sourceDimension);
                continue;
            }
            targetTypeBuilder.mapped(sourceDimension.name());
        }
        TensorType targetType = targetTypeBuilder.build();
        if (tensor.type().equals(targetType)) {
            return tensor;
        }
        Tensor.Builder builder = Tensor.Builder.of(targetType);
        Iterator<Tensor.Cell> i = tensor.cellIterator();
        while (i.hasNext()) {
            builder.cell(i.next());
        }
        return builder.build();
    }

    public static Tensor packBits(Tensor tensor) {
        if (tensor.type().indexedSubtype().dimensions().size() != 1) {
            throw new IllegalArgumentException("packBits requires a tensor with one dense dimensions, but got " + tensor.type());
        }
        TensorType.Builder typeBuilder = new TensorType.Builder(TensorType.Value.INT8);
        for (TensorType.Dimension d : tensor.type().dimensions()) {
            typeBuilder.dimension(d.size().isPresent() ? d.withSize((int)Math.ceil((double)d.size().get().longValue() / 8.0)) : d);
        }
        TensorType packedType = typeBuilder.build();
        Tensor.Builder builder = Tensor.Builder.of(packedType);
        if (tensor instanceof IndexedTensor) {
            IndexedTensor indexed = (IndexedTensor)tensor;
            long i = 0L;
            while (i < indexed.size()) {
                long packedIndex = i / 8L;
                int packedValue = 0;
                for (int j = 0; j < 8 && i < indexed.size(); ++j) {
                    packedValue = Tensors.packInto(packedValue, indexed.get(i), j, i++);
                }
                builder.cell(packedValue, new long[]{packedIndex});
            }
        } else if (tensor instanceof MixedTensor) {
            MixedTensor mixed = (MixedTensor)tensor;
            for (MixedTensor.DenseSubspace denseSubspace : mixed.getInternalDenseSubspaces()) {
                int i = 0;
                while (i < denseSubspace.cells.length) {
                    TensorAddress packedAddress = denseSubspace.sparseAddress.fullAddressOf(mixed.type().dimensions(), new int[]{i / 8});
                    int packedValue = 0;
                    for (int j = 0; j < 8 && i < denseSubspace.cells.length; ++j) {
                        packedValue = Tensors.packInto(packedValue, denseSubspace.cells[i], j, i++);
                    }
                    builder.cell(packedAddress, (float)packedValue);
                }
            }
        } else {
            throw new IllegalArgumentException("The argument is neither of type IndexedTensor or MixedTensor, but " + tensor.getClass());
        }
        return builder.build();
    }

    private static int packInto(int packedValue, double value, int bitPosition, long sourcePosition) {
        if (value == 0.0) {
            return packedValue;
        }
        if (value == 1.0) {
            return packedValue | 1 << 7 - bitPosition;
        }
        throw new IllegalArgumentException("The tensor to be packed can only contain 0 or 1 values, but has " + value + " at position " + sourcePosition);
    }
}

