/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.stream;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class CustomCollectors {
    private CustomCollectors() {
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toLinkedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.toMap(keyMapper, valueMapper, CustomCollectors.throwingMerger(), LinkedHashMap::new);
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toCustomMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, Supplier<M> mapSupplier) {
        return Collectors.toMap(keyMapper, valueMapper, CustomCollectors.throwingMerger(), mapSupplier);
    }

    public static <T> Collector<T, ?, Optional<T>> singleton() {
        return Collectors.collectingAndThen(Collectors.toList(), list -> {
            if (list.size() > 1) {
                throw new IllegalArgumentException("More than one element");
            }
            return list.stream().findAny();
        });
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new DuplicateKeyException(u);
        };
    }

    public static class DuplicateKeyException
    extends IllegalStateException {
        private static final long serialVersionUID = 1L;

        DuplicateKeyException(Object key) {
            super(String.format("Duplicate keys: %s", key));
        }
    }
}

