/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor;

import com.yahoo.api.annotations.Beta;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import java.util.Arrays;
import java.util.Iterator;

@Beta
public class Tensors {
    public static Tensor toSparse(Tensor tensor, String ... dimensions) {
        for (String dimension : dimensions) {
            if (!tensor.type().dimension(dimension).isEmpty()) continue;
            throw new IllegalArgumentException("The tensor " + tensor.type() + " is missing the specified dimension '" + dimension + "'");
        }
        if (dimensions.length == 0) {
            dimensions = (String[])tensor.type().dimensions().stream().map(TensorType.Dimension::name).toArray(String[]::new);
        }
        TensorType.Builder targetTypeBuilder = new TensorType.Builder();
        for (TensorType.Dimension sourceDimension : tensor.type().dimensions()) {
            if (sourceDimension.isMapped() || Arrays.stream(dimensions).noneMatch(d -> d.equals(sourceDimension.name()))) {
                targetTypeBuilder.dimension(sourceDimension);
                continue;
            }
            targetTypeBuilder.mapped(sourceDimension.name());
        }
        TensorType targetType = targetTypeBuilder.build();
        if (tensor.type().equals(targetType)) {
            return tensor;
        }
        Tensor.Builder builder = Tensor.Builder.of(targetType);
        Iterator<Tensor.Cell> i = tensor.cellIterator();
        while (i.hasNext()) {
            builder.cell(i.next());
        }
        return builder.build();
    }
}

