/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.serialization;

import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.tensor.DimensionSizes;
import com.yahoo.tensor.IndexedTensor;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.serialization.BinaryFormat;
import com.yahoo.tensor.serialization.TypedBinaryFormat;
import java.util.Optional;

public class DenseBinaryFormat
implements BinaryFormat {
    private final TensorType.Value serializationValueType;

    DenseBinaryFormat() {
        this(TensorType.Value.DOUBLE);
    }

    DenseBinaryFormat(TensorType.Value serializationValueType) {
        this.serializationValueType = serializationValueType;
    }

    @Override
    public void encode(GrowableByteBuffer buffer, Tensor tensor) {
        if (!(tensor instanceof IndexedTensor)) {
            throw new RuntimeException("The dense format is only supported for indexed tensors");
        }
        this.encodeDimensions(buffer, (IndexedTensor)tensor);
        this.encodeCells(buffer, (IndexedTensor)tensor);
    }

    private void encodeDimensions(GrowableByteBuffer buffer, IndexedTensor tensor) {
        buffer.putInt1_4Bytes(tensor.type().dimensions().size());
        for (int i = 0; i < tensor.type().dimensions().size(); ++i) {
            buffer.putUtf8String(tensor.type().dimensions().get(i).name());
            buffer.putInt1_4Bytes((int)tensor.dimensionSizes().size(i));
        }
    }

    private void encodeCells(GrowableByteBuffer buffer, IndexedTensor tensor) {
        switch (this.serializationValueType) {
            case DOUBLE: {
                this.encodeDoubleCells(tensor, buffer);
                break;
            }
            case FLOAT: {
                this.encodeFloatCells(tensor, buffer);
                break;
            }
            case BFLOAT16: {
                this.encodeBFloat16Cells(tensor, buffer);
                break;
            }
            case INT8: {
                this.encodeInt8Cells(tensor, buffer);
            }
        }
    }

    private void encodeDoubleCells(IndexedTensor tensor, GrowableByteBuffer buffer) {
        for (int i = 0; i < tensor.sizeAsInt(); ++i) {
            buffer.putDouble(tensor.get((long)i));
        }
    }

    private void encodeFloatCells(IndexedTensor tensor, GrowableByteBuffer buffer) {
        for (int i = 0; i < tensor.sizeAsInt(); ++i) {
            buffer.putFloat(tensor.getFloat((long)i));
        }
    }

    private void encodeBFloat16Cells(IndexedTensor tensor, GrowableByteBuffer buffer) {
        for (int i = 0; i < tensor.sizeAsInt(); ++i) {
            buffer.putShort(TypedBinaryFormat.bFloat16BitsFromFloat(tensor.getFloat((long)i)));
        }
    }

    private void encodeInt8Cells(IndexedTensor tensor, GrowableByteBuffer buffer) {
        for (int i = 0; i < tensor.sizeAsInt(); ++i) {
            buffer.put((byte)tensor.getFloat((long)i));
        }
    }

    @Override
    public Tensor decode(Optional<TensorType> optionalType, GrowableByteBuffer buffer) {
        DimensionSizes sizes;
        TensorType type;
        if (optionalType.isPresent()) {
            type = optionalType.get();
            if (type.valueType() != this.serializationValueType) {
                throw new IllegalArgumentException("Tensor value type mismatch. Value type " + type.valueType() + " is not " + this.serializationValueType);
            }
            TensorType serializedType = this.decodeType(buffer);
            if (!serializedType.isAssignableTo(type)) {
                throw new IllegalArgumentException("Type/instance mismatch: A tensor of type " + serializedType + " cannot be assigned to type " + type);
            }
            sizes = this.sizesFromType(serializedType);
        } else {
            type = this.decodeType(buffer);
            sizes = this.sizesFromType(type);
        }
        Tensor.Builder builder = Tensor.Builder.of(type, sizes);
        this.decodeCells(sizes, buffer, (IndexedTensor.BoundBuilder)builder);
        return builder.build();
    }

    private TensorType decodeType(GrowableByteBuffer buffer) {
        TensorType.Builder builder = new TensorType.Builder(this.serializationValueType);
        int dimensionCount = buffer.getInt1_4Bytes();
        for (int i = 0; i < dimensionCount; ++i) {
            builder.indexed(buffer.getUtf8String(), buffer.getInt1_4Bytes());
        }
        return builder.build();
    }

    private DimensionSizes sizesFromType(TensorType type) {
        DimensionSizes.Builder builder = new DimensionSizes.Builder(type.dimensions().size());
        for (int i = 0; i < type.dimensions().size(); ++i) {
            builder.set(i, type.dimensions().get(i).size().get());
        }
        return builder.build();
    }

    private void decodeCells(DimensionSizes sizes, GrowableByteBuffer buffer, IndexedTensor.BoundBuilder builder) {
        switch (this.serializationValueType) {
            case DOUBLE: {
                this.decodeDoubleCells(sizes, builder, buffer);
                break;
            }
            case FLOAT: {
                this.decodeFloatCells(sizes, builder, buffer);
                break;
            }
            case BFLOAT16: {
                this.decodeBFloat16Cells(sizes, builder, buffer);
                break;
            }
            case INT8: {
                this.decodeInt8Cells(sizes, builder, buffer);
            }
        }
    }

    private void decodeDoubleCells(DimensionSizes sizes, IndexedTensor.BoundBuilder builder, GrowableByteBuffer buffer) {
        for (long i = 0L; i < sizes.totalSize(); ++i) {
            builder.cellByDirectIndex(i, buffer.getDouble());
        }
    }

    private void decodeFloatCells(DimensionSizes sizes, IndexedTensor.BoundBuilder builder, GrowableByteBuffer buffer) {
        for (long i = 0L; i < sizes.totalSize(); ++i) {
            builder.cellByDirectIndex(i, buffer.getFloat());
        }
    }

    private void decodeBFloat16Cells(DimensionSizes sizes, IndexedTensor.BoundBuilder builder, GrowableByteBuffer buffer) {
        for (long i = 0L; i < sizes.totalSize(); ++i) {
            builder.cellByDirectIndex(i, TypedBinaryFormat.floatFromBFloat16Bits(buffer.getShort()));
        }
    }

    private void decodeInt8Cells(DimensionSizes sizes, IndexedTensor.BoundBuilder builder, GrowableByteBuffer buffer) {
        for (long i = 0L; i < sizes.totalSize(); ++i) {
            builder.cellByDirectIndex(i, buffer.get());
        }
    }
}

