/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.concurrent.maintenance;

import com.yahoo.concurrent.UncheckedTimeoutException;
import com.yahoo.concurrent.maintenance.JobControl;
import com.yahoo.concurrent.maintenance.JobMetrics;
import com.yahoo.net.HostName;
import com.yahoo.transaction.Mutex;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Maintainer
implements Runnable {
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private final String name;
    private final JobControl jobControl;
    private final JobMetrics jobMetrics;
    private final Duration interval;
    private final ScheduledExecutorService service;
    private final AtomicBoolean shutDown = new AtomicBoolean();
    private final boolean ignoreCollision;
    private final Clock clock;
    private final double successFactorBaseline;
    private final boolean acquireLock;

    public Maintainer(String name, Duration interval, Clock clock, JobControl jobControl, JobMetrics jobMetrics, List<String> clusterHostnames, boolean ignoreCollision, double successFactorBaseline, boolean acquireLock) {
        this.name = name;
        this.interval = Maintainer.requireInterval(interval);
        this.jobControl = Objects.requireNonNull(jobControl);
        this.jobMetrics = Objects.requireNonNull(jobMetrics);
        this.ignoreCollision = ignoreCollision;
        this.clock = clock;
        this.successFactorBaseline = successFactorBaseline;
        this.acquireLock = acquireLock;
        Duration initialDelay = this.staggeredDelay(interval, HostName.getLocalhost(), clusterHostnames).plus(Duration.ofSeconds(30L));
        this.service = new ScheduledThreadPoolExecutor(1, r -> new Thread(r, this.name() + "-worker"));
        this.service.scheduleAtFixedRate(this, initialDelay.toMillis(), interval.toMillis(), TimeUnit.MILLISECONDS);
        jobControl.started(this.name(), this);
        if (ignoreCollision && !acquireLock) {
            throw new IllegalArgumentException("ignoreCollision=" + ignoreCollision + ", but collisions cannot happen when acquireLock=" + acquireLock);
        }
    }

    public Maintainer(String name, Duration interval, Clock clock, JobControl jobControl, JobMetrics jobMetrics, List<String> clusterHostnames, boolean ignoreCollision) {
        this(name, interval, clock, jobControl, jobMetrics, clusterHostnames, ignoreCollision, 1.0, true);
    }

    @Override
    public void run() {
        this.doMaintain(false);
    }

    public void shutdown() {
        if (!this.shutDown.getAndSet(true)) {
            this.service.shutdown();
        }
    }

    public void awaitShutdown() {
        this.shutdown();
        Duration timeout = Duration.ofSeconds(30L);
        try {
            if (!this.service.awaitTermination(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
                this.log.log(Level.WARNING, "Maintainer " + this.name() + " failed to shutdown within " + timeout);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public final boolean shuttingDown() {
        return this.shutDown.get();
    }

    public final String toString() {
        return this.name();
    }

    protected abstract double maintain();

    protected final double asSuccessFactorDeviation(int attempts, int failures) {
        double factor = attempts == 0 ? 1.0 : 1.0 - (double)failures / (double)attempts;
        return new BigDecimal(factor - this.successFactorBaseline).setScale(5, RoundingMode.HALF_UP).doubleValue();
    }

    protected Duration interval() {
        return this.interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doMaintain(boolean force) {
        block16: {
            if (!force && !this.jobControl.isActive(this.name())) {
                return;
            }
            this.log.log(Level.FINE, () -> "Running " + this.getClass().getSimpleName());
            double successFactorDeviation = -1.0;
            long startTime = this.clock.millis();
            try {
                if (this.acquireLock) {
                    try (Mutex lock = this.jobControl.lockJob(this.name());){
                        successFactorDeviation = this.maintain();
                        break block16;
                    }
                    catch (UncheckedTimeoutException e) {
                        if (this.ignoreCollision) {
                            successFactorDeviation = 0.0;
                            break block16;
                        }
                        this.log.log(Level.WARNING, this + " collided with another run. Will retry in " + this.interval);
                    }
                    break block16;
                }
                successFactorDeviation = this.maintain();
            }
            catch (Throwable e) {
                this.log.log(Level.WARNING, this + " failed. Will retry in " + this.interval, e);
            }
            finally {
                long endTime = this.clock.millis();
                this.jobMetrics.completed(this.name(), successFactorDeviation, endTime - startTime);
            }
        }
        this.log.log(Level.FINE, () -> "Finished " + this.getClass().getSimpleName());
    }

    public final String name() {
        return this.name == null ? this.getClass().getSimpleName() : this.name;
    }

    Duration staggeredDelay(Duration interval, String hostname, List<String> clusterHostnames) {
        Objects.requireNonNull(clusterHostnames);
        if (!clusterHostnames.contains(hostname)) {
            return interval;
        }
        Instant now = this.clock.instant();
        long nodeOffset = (long)clusterHostnames.indexOf(hostname) * interval.toMillis() / (long)clusterHostnames.size();
        long maintainerOffset = (long)this.getClass().getName().hashCode() % interval.toMillis();
        long totalOffset = nodeOffset + maintainerOffset;
        return Duration.ofMillis(Math.floorMod(totalOffset - now.toEpochMilli(), interval.toMillis()));
    }

    private static Duration requireInterval(Duration interval) {
        Objects.requireNonNull(interval);
        if (interval.isNegative() || interval.isZero()) {
            throw new IllegalArgumentException("Interval must be positive, but was " + interval);
        }
        return interval;
    }
}

