/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.impl;

import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.impl.Label;
import com.yahoo.tensor.impl.TensorAddressAny1;
import com.yahoo.tensor.impl.TensorAddressAny2;
import com.yahoo.tensor.impl.TensorAddressAny3;
import com.yahoo.tensor.impl.TensorAddressAny4;
import com.yahoo.tensor.impl.TensorAddressAnyN;
import com.yahoo.tensor.impl.TensorAddressEmpty;
import java.util.Arrays;

public abstract class TensorAddressAny
extends TensorAddress {
    @Override
    public String label(int i) {
        return Label.fromNumber(this.numericLabel(i));
    }

    public static TensorAddress of() {
        return TensorAddressEmpty.empty;
    }

    public static TensorAddress of(String label) {
        return new TensorAddressAny1(Label.toNumber(label));
    }

    public static TensorAddress of(String label0, String label1) {
        return new TensorAddressAny2(Label.toNumber(label0), Label.toNumber(label1));
    }

    public static TensorAddress of(String label0, String label1, String label2) {
        return new TensorAddressAny3(Label.toNumber(label0), Label.toNumber(label1), Label.toNumber(label2));
    }

    public static TensorAddress of(String label0, String label1, String label2, String label3) {
        return new TensorAddressAny4(Label.toNumber(label0), Label.toNumber(label1), Label.toNumber(label2), Label.toNumber(label3));
    }

    public static TensorAddress of(String[] labels) {
        long[] labelsAsLong = new long[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            labelsAsLong[i] = Label.toNumber(labels[i]);
        }
        return TensorAddressAny.ofUnsafe(labelsAsLong);
    }

    public static TensorAddress of(int label) {
        return new TensorAddressAny1(TensorAddressAny.sanitize(label));
    }

    public static TensorAddress of(int label0, int label1) {
        return new TensorAddressAny2(TensorAddressAny.sanitize(label0), TensorAddressAny.sanitize(label1));
    }

    public static TensorAddress of(int label0, int label1, int label2) {
        return new TensorAddressAny3(TensorAddressAny.sanitize(label0), TensorAddressAny.sanitize(label1), TensorAddressAny.sanitize(label2));
    }

    public static TensorAddress of(int label0, int label1, int label2, int label3) {
        return new TensorAddressAny4(TensorAddressAny.sanitize(label0), TensorAddressAny.sanitize(label1), TensorAddressAny.sanitize(label2), TensorAddressAny.sanitize(label3));
    }

    public static TensorAddress of(int ... labels) {
        return switch (labels.length) {
            case 0 -> TensorAddressAny.of();
            case 1 -> TensorAddressAny.of(labels[0]);
            case 2 -> TensorAddressAny.of(labels[0], labels[1]);
            case 3 -> TensorAddressAny.of(labels[0], labels[1], labels[2]);
            case 4 -> TensorAddressAny.of(labels[0], labels[1], labels[2], labels[3]);
            default -> {
                long[] copy = new long[labels.length];
                for (int i = 0; i < labels.length; ++i) {
                    copy[i] = TensorAddressAny.sanitize(labels[i]);
                }
                yield new TensorAddressAnyN(copy);
            }
        };
    }

    public static TensorAddress of(long ... labels) {
        return switch (labels.length) {
            case 0 -> TensorAddressAny.of();
            case 1 -> TensorAddressAny.of(labels[0]);
            case 2 -> TensorAddressAny.of(labels[0], labels[1]);
            case 3 -> TensorAddressAny.of(labels[0], labels[1], labels[2]);
            case 4 -> TensorAddressAny.of(labels[0], labels[1], labels[2], labels[3]);
            default -> new TensorAddressAnyN(Arrays.copyOf(labels, labels.length));
        };
    }

    private static TensorAddress of(long label) {
        return new TensorAddressAny1(label);
    }

    private static TensorAddress of(long label0, long label1) {
        return new TensorAddressAny2(label0, label1);
    }

    public static TensorAddress of(long label0, long label1, long label2) {
        return new TensorAddressAny3(label0, label1, label2);
    }

    public static TensorAddress of(long label0, long label1, long label2, long label3) {
        return new TensorAddressAny4(label0, label1, label2, label3);
    }

    public static TensorAddress ofUnsafe(long ... labels) {
        return switch (labels.length) {
            case 0 -> TensorAddressAny.of();
            case 1 -> TensorAddressAny.of(labels[0]);
            case 2 -> TensorAddressAny.of(labels[0], labels[1]);
            case 3 -> TensorAddressAny.of(labels[0], labels[1], labels[2]);
            case 4 -> TensorAddressAny.of(labels[0], labels[1], labels[2], labels[3]);
            default -> new TensorAddressAnyN(labels);
        };
    }

    private static long sanitize(long label) {
        if (label < -1L) {
            throw new IndexOutOfBoundsException("cell label " + label + " must be positive");
        }
        return label;
    }
}

