/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.objects;

import com.yahoo.collections.Pair;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.ObjectDumper;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Selectable;
import com.yahoo.vespa.objects.Serializer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.function.Supplier;

public class Identifiable
extends Selectable
implements Cloneable {
    private static Registry registry = null;
    public static int classId = Identifiable.registerClass(1, Identifiable.class);

    public final int getClassId() {
        return this.onGetClassId();
    }

    protected int onGetClassId() {
        return classId;
    }

    public final Serializer serializeWithId(Serializer buf) {
        buf.putInt(null, this.getClassId());
        return this.serialize(buf);
    }

    public final Serializer serialize(Serializer buf) {
        this.onSerialize(buf);
        return buf;
    }

    protected void onSerialize(Serializer buf) {
    }

    public final Deserializer deserializeWithId(Deserializer buf) {
        int id = buf.getInt(null);
        if (id != this.getClassId()) {
            Class<? extends Identifiable> spec = registry.get(id);
            if (spec != null) {
                throw new IllegalArgumentException("Can not deserialize class '" + this.getClass().getName() + "' (id " + this.getClassId() + ") from buffer containing class '" + spec.getName() + "' (id " + id + ").");
            }
            throw new IllegalArgumentException("Can not deserialize class '" + this.getClass().getName() + "' (id " + this.getClassId() + ") from buffer containing unknown class id " + id + ".");
        }
        return this.deserialize(buf);
    }

    public final Deserializer deserialize(Deserializer buf) {
        this.onDeserialize(buf);
        return buf;
    }

    protected void onDeserialize(Deserializer buf) {
    }

    public Identifiable clone() {
        try {
            return (Identifiable)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"The cloneable structure has been broken."))).initCause(e));
        }
    }

    public int hashCode() {
        return this.getClassId();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Identifiable)) {
            return false;
        }
        Identifiable rhs = (Identifiable)obj;
        return this.getClassId() == rhs.getClassId();
    }

    public String toString() {
        ObjectDumper ret = new ObjectDumper();
        ret.visit("", this);
        return ret.toString();
    }

    protected static int registerClass(int id, Class<? extends Identifiable> spec) {
        if (registry == null) {
            registry = new Registry();
        }
        registry.add(id, spec);
        return id;
    }

    protected static int registerClass(int id, Class<? extends Identifiable> spec, Supplier<? extends Identifiable> creator) {
        if (registry == null) {
            registry = new Registry();
        }
        registry.add(id, spec, creator);
        return id;
    }

    public static Identifiable create(Deserializer buf) {
        int classId = buf.getInt(null);
        Identifiable obj = Identifiable.createFromId(classId);
        if (obj == null) {
            throw new IllegalArgumentException("Failed creating class for classId " + classId);
        }
        obj.deserialize(buf);
        return obj;
    }

    public static Identifiable createFromId(int id) {
        return registry.createFromId(id);
    }

    protected static Serializer serializeOptional(Serializer buf, Identifiable obj) {
        if (obj != null) {
            buf.putByte(null, (byte)1);
            obj.serializeWithId(buf);
        } else {
            buf.putByte(null, (byte)0);
        }
        return buf;
    }

    protected static Identifiable deserializeOptional(Deserializer buf) {
        byte hasObject = buf.getByte(null);
        if (hasObject == 1) {
            return Identifiable.create(buf);
        }
        return null;
    }

    protected static boolean equals(Object lhs, Object rhs) {
        return !(lhs == null && rhs != null || lhs != null && rhs == null || lhs != null && !lhs.equals(rhs));
    }

    public void visitMembers(ObjectVisitor visitor) {
        visitor.visit("classId", this.getClassId());
    }

    protected static byte[] getRawUtf8Bytes(Deserializer buf) {
        int len = buf.getInt(null);
        return buf.getBytes(null, len);
    }

    protected String getUtf8(Deserializer buf) {
        return Utf8.toString(Identifiable.getRawUtf8Bytes(buf));
    }

    protected void putUtf8(Serializer buf, String val) {
        byte[] raw = Utf8.toBytes(val);
        buf.putInt(null, raw.length);
        buf.put(null, raw);
    }

    private static class Registry {
        private final HashMap<Integer, Pair<Class<? extends Identifiable>, Supplier<? extends Identifiable>>> typeMap = new HashMap();

        private Registry() {
        }

        private void add(int id, Class<? extends Identifiable> spec) {
            CreateFromConstructor creator;
            try {
                creator = new CreateFromConstructor(spec.getConstructor(new Class[0]));
            }
            catch (NoSuchMethodException e) {
                creator = null;
            }
            this.add(id, spec, creator);
        }

        private void add(int id, Class<? extends Identifiable> spec, Supplier<? extends Identifiable> construct) {
            Class<? extends Identifiable> old = this.get(id);
            if (old == null) {
                this.typeMap.put(id, new Pair<Class<? extends Identifiable>, Supplier<? extends Identifiable>>(spec, construct));
            } else if (!spec.equals(old)) {
                throw new IllegalArgumentException("Can not register class '" + spec + "' with id " + id + ", because it already maps to class '" + old + "'.");
            }
        }

        private Class<? extends Identifiable> get(int id) {
            Pair<Class<? extends Identifiable>, Supplier<? extends Identifiable>> pair = this.typeMap.get(id);
            return pair != null ? pair.getFirst() : null;
        }

        private Identifiable createFromId(int id) {
            Pair<Class<? extends Identifiable>, Supplier<? extends Identifiable>> pair = this.typeMap.get(id);
            return pair != null ? pair.getSecond().get() : null;
        }

        private static class CreateFromConstructor
        implements Supplier<Identifiable> {
            private final Constructor<? extends Identifiable> constructor;

            CreateFromConstructor(Constructor<? extends Identifiable> constructor) {
                this.constructor = constructor;
            }

            @Override
            public Identifiable get() {
                Identifiable obj = null;
                if (this.constructor != null) {
                    try {
                        obj = this.constructor.newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        throw new IllegalArgumentException("Failed to create object from class '" + this.constructor.getName() + "'.", e);
                    }
                }
                return obj;
            }
        }
    }
}

