/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.protect;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public final class ClassValidator {
    public static List<Method> unmaskedMethods(Class<?> testClass, Class<?> maskedClass) {
        Method[] methodsToMask;
        ArrayList<Method> unmasked = new ArrayList<Method>();
        for (Method m : methodsToMask = maskedClass.getDeclaredMethods()) {
            int modifiers = m.getModifiers();
            if (Modifier.isPrivate(modifiers)) continue;
            try {
                testClass.getDeclaredMethod(m.getName(), m.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                unmasked.add(m);
            }
        }
        return unmasked;
    }

    public static List<Method> unmaskedMethodsFromSuperclass(Class<?> testClass) {
        return ClassValidator.unmaskedMethods(testClass, testClass.getSuperclass());
    }
}

