/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.impl;

import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.impl.NumericTensorAddress;
import java.util.Arrays;

public final class StringTensorAddress
extends TensorAddress {
    private final String[] labels;

    private StringTensorAddress(String[] labels) {
        this.labels = labels;
    }

    public static StringTensorAddress of(String[] labels) {
        return new StringTensorAddress(Arrays.copyOf(labels, labels.length));
    }

    public static StringTensorAddress unsafeOf(String[] labels) {
        return new StringTensorAddress(labels);
    }

    @Override
    public int size() {
        return this.labels.length;
    }

    @Override
    public String label(int i) {
        return this.labels[i];
    }

    @Override
    public long numericLabel(int i) {
        try {
            return Long.parseLong(this.labels[i]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected an integer label in " + this + " at position " + i + " but got '" + this.labels[i] + "'");
        }
    }

    @Override
    public TensorAddress withLabel(int index, long label) {
        String[] labels = Arrays.copyOf(this.labels, this.labels.length);
        labels[index] = NumericTensorAddress.asString(label);
        return new StringTensorAddress(labels);
    }

    public String toString() {
        return "cell address (" + String.join((CharSequence)",", this.labels) + ")";
    }
}

