/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor;

import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.impl.StringTensorAddress;
import java.util.Arrays;

public class PartialAddress {
    private final String[] dimensionNames;
    private final Object[] labels;

    private PartialAddress(Builder builder) {
        this.dimensionNames = builder.dimensionNames;
        this.labels = builder.labels;
        builder.dimensionNames = null;
        builder.labels = null;
    }

    public String dimension(int i) {
        return this.dimensionNames[i];
    }

    public long numericLabel(String dimensionName) {
        for (int i = 0; i < this.dimensionNames.length; ++i) {
            if (!this.dimensionNames[i].equals(dimensionName)) continue;
            return this.asLong(this.labels[i]);
        }
        return -1L;
    }

    public String label(String dimensionName) {
        for (int i = 0; i < this.dimensionNames.length; ++i) {
            if (!this.dimensionNames[i].equals(dimensionName)) continue;
            return this.labels[i].toString();
        }
        return null;
    }

    public String label(int i) {
        if (i >= this.size()) {
            throw new IllegalArgumentException("No label at position " + i + " in " + this);
        }
        return this.labels[i].toString();
    }

    public int size() {
        return this.dimensionNames.length;
    }

    public TensorAddress asAddress(TensorType type) {
        if (type.rank() != this.size()) {
            throw new IllegalArgumentException(type + " has a different rank than " + this);
        }
        if (Arrays.stream(this.labels).allMatch(l -> l instanceof Long)) {
            long[] numericLabels = new long[this.labels.length];
            for (int i = 0; i < type.dimensions().size(); ++i) {
                long label = this.numericLabel(type.dimensions().get(i).name());
                if (label < 0L) {
                    throw new IllegalArgumentException(type + " dimension names does not match " + this);
                }
                numericLabels[i] = label;
            }
            return TensorAddress.of(numericLabels);
        }
        String[] stringLabels = new String[this.labels.length];
        for (int i = 0; i < type.dimensions().size(); ++i) {
            String label = this.label(type.dimensions().get(i).name());
            if (label == null) {
                throw new IllegalArgumentException(type + " dimension names does not match " + this);
            }
            stringLabels[i] = label;
        }
        return StringTensorAddress.unsafeOf(stringLabels);
    }

    private long asLong(Object label) {
        if (label instanceof Long) {
            return (Long)label;
        }
        try {
            return Long.parseLong(label.toString());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Label '" + label + "' is not numeric");
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder("Partial address {");
        for (int i = 0; i < this.dimensionNames.length; ++i) {
            b.append(this.dimensionNames[i]).append(":").append(this.label(i)).append(", ");
        }
        if (this.size() > 0) {
            b.setLength(b.length() - 2);
        }
        return b.toString();
    }

    public static class Builder {
        private String[] dimensionNames;
        private Object[] labels;
        private int index = 0;

        public Builder(int size) {
            this.dimensionNames = new String[size];
            this.labels = new Object[size];
        }

        public Builder add(String dimensionName, long label) {
            this.dimensionNames[this.index] = dimensionName;
            this.labels[this.index] = label;
            ++this.index;
            return this;
        }

        public Builder add(String dimensionName, String label) {
            this.dimensionNames[this.index] = dimensionName;
            this.labels[this.index] = label;
            ++this.index;
            return this;
        }

        public PartialAddress build() {
            return new PartialAddress(this);
        }
    }
}

