/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor;

import com.yahoo.tensor.DimensionSizes;

public final class DirectIndexedAddress {
    private final DimensionSizes sizes;
    private final int[] indexes;
    private long directIndex;

    private DirectIndexedAddress(DimensionSizes sizes) {
        this.sizes = sizes;
        this.indexes = new int[sizes.dimensions()];
        this.directIndex = 0L;
    }

    static DirectIndexedAddress of(DimensionSizes sizes) {
        return new DirectIndexedAddress(sizes);
    }

    public void setIndex(int dimension, int index) {
        if (index < 0 || (long)index >= this.sizes.size(dimension)) {
            throw new IndexOutOfBoundsException("Index " + index + " outside of [0," + this.sizes.size(dimension) + ">");
        }
        int diff = index - this.indexes[dimension];
        this.directIndex += this.getStride(dimension) * (long)diff;
        this.indexes[dimension] = index;
    }

    public long getDirectIndex() {
        return this.directIndex;
    }

    public long getStride(int dimension) {
        return this.sizes.productOfDimensionsAfter(dimension);
    }
}

