/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor;

import com.google.common.collect.ImmutableMap;
import com.yahoo.tensor.IndexedTensor;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MixedTensor
implements Tensor {
    private final TensorType type;
    private final int denseSubspaceSize;
    private final List<DenseSubspace> denseSubspaces;
    private final Index index;

    public List<DenseSubspace> getInternalDenseSubspaces() {
        return this.denseSubspaces;
    }

    private MixedTensor(TensorType type, List<DenseSubspace> denseSubspaces, Index index) {
        this.type = type;
        this.denseSubspaceSize = index.denseSubspaceSize();
        this.denseSubspaces = List.copyOf(denseSubspaces);
        this.index = index;
        if (this.denseSubspaceSize < 1) {
            throw new IllegalStateException("invalid dense subspace size: " + this.denseSubspaceSize);
        }
        long count = 0L;
        for (DenseSubspace block : this.denseSubspaces) {
            if ((long)((Integer)index.sparseMap.get((Object)block.sparseAddress)).intValue() != count) {
                throw new IllegalStateException("map vs list mismatch: block #" + count + " address maps to #" + index.sparseMap.get((Object)block.sparseAddress));
            }
            if (block.cells.length != this.denseSubspaceSize) {
                throw new IllegalStateException("dense subspace size mismatch, expected " + this.denseSubspaceSize + " cells, but got: " + block.cells.length);
            }
            ++count;
        }
        if (count != (long)index.sparseMap.size()) {
            throw new IllegalStateException("mismatch: list size is " + count + " but map size is " + index.sparseMap.size());
        }
    }

    @Override
    public TensorType type() {
        return this.type;
    }

    @Override
    public long size() {
        return this.denseSubspaces.size() * this.denseSubspaceSize;
    }

    @Override
    public double get(TensorAddress address) {
        int blockNum = this.index.blockIndexOf(address);
        if (blockNum < 0 || blockNum > this.denseSubspaces.size()) {
            return 0.0;
        }
        int denseOffset = this.index.denseOffsetOf(address);
        DenseSubspace block = this.denseSubspaces.get(blockNum);
        if (denseOffset < 0 || denseOffset >= block.cells.length) {
            return 0.0;
        }
        return block.cells[denseOffset];
    }

    @Override
    public boolean has(TensorAddress address) {
        int blockNum = this.index.blockIndexOf(address);
        if (blockNum < 0 || blockNum > this.denseSubspaces.size()) {
            return false;
        }
        int denseOffset = this.index.denseOffsetOf(address);
        DenseSubspace block = this.denseSubspaces.get(blockNum);
        return denseOffset >= 0 && denseOffset < block.cells.length;
    }

    @Override
    public Iterator<Tensor.Cell> cellIterator() {
        return new Iterator<Tensor.Cell>(){
            final Iterator<DenseSubspace> blockIterator;
            DenseSubspace currBlock;
            int currOffset;
            {
                this.blockIterator = MixedTensor.this.denseSubspaces.iterator();
                this.currBlock = null;
                this.currOffset = MixedTensor.this.denseSubspaceSize;
            }

            @Override
            public boolean hasNext() {
                return this.currOffset < MixedTensor.this.denseSubspaceSize || this.blockIterator.hasNext();
            }

            @Override
            public Tensor.Cell next() {
                if (this.currOffset == MixedTensor.this.denseSubspaceSize) {
                    this.currBlock = this.blockIterator.next();
                    this.currOffset = 0;
                }
                TensorAddress fullAddr = MixedTensor.this.index.fullAddressOf(this.currBlock.sparseAddress, this.currOffset);
                double value = this.currBlock.cells[this.currOffset++];
                return new Tensor.Cell(fullAddr, value);
            }
        };
    }

    @Override
    public Iterator<Double> valueIterator() {
        return new Iterator<Double>(){
            final Iterator<DenseSubspace> blockIterator;
            double[] currBlock;
            int currOffset;
            {
                this.blockIterator = MixedTensor.this.denseSubspaces.iterator();
                this.currBlock = null;
                this.currOffset = MixedTensor.this.denseSubspaceSize;
            }

            @Override
            public boolean hasNext() {
                return this.currOffset < MixedTensor.this.denseSubspaceSize || this.blockIterator.hasNext();
            }

            @Override
            public Double next() {
                if (this.currOffset == MixedTensor.this.denseSubspaceSize) {
                    this.currBlock = this.blockIterator.next().cells;
                    this.currOffset = 0;
                }
                return this.currBlock[this.currOffset++];
            }
        };
    }

    @Override
    public Map<TensorAddress, Double> cells() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        Iterator<Tensor.Cell> iter = this.cellIterator();
        while (iter.hasNext()) {
            Tensor.Cell cell = iter.next();
            builder.put((Object)cell.getKey(), (Object)cell.getValue());
        }
        return builder.build();
    }

    @Override
    public Tensor withType(TensorType other) {
        if (!this.type.isRenamableTo(this.type)) {
            throw new IllegalArgumentException("MixedTensor.withType: types are not compatible. Current type: '" + this.type + "', requested type: '" + this.type + "'");
        }
        return new MixedTensor(other, this.denseSubspaces, this.index);
    }

    @Override
    public Tensor remove(Set<TensorAddress> addresses) {
        Index.Builder indexBuilder = new Index.Builder(this.type);
        ArrayList<DenseSubspace> list = new ArrayList<DenseSubspace>();
        for (DenseSubspace block : this.denseSubspaces) {
            if (addresses.contains(block.sparseAddress)) continue;
            indexBuilder.addBlock(block.sparseAddress, list.size());
            list.add(block);
        }
        return new MixedTensor(this.type, list, indexBuilder.build());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.denseSubspaces);
    }

    @Override
    public String toString() {
        return this.toString(true, true);
    }

    @Override
    public String toString(boolean withType, boolean shortForms) {
        return this.toString(withType, shortForms, Long.MAX_VALUE);
    }

    @Override
    public String toAbbreviatedString(boolean withType, boolean shortForms) {
        return this.toString(withType, shortForms, Math.max(2L, 10L / (this.type().dimensions().stream().filter(TensorType.Dimension::isMapped).count() + 1L)));
    }

    private String toString(boolean withType, boolean shortForms, long maxCells) {
        if (!shortForms || this.type.rank() == 0 || this.type.rank() > 1 && this.type.dimensions().stream().filter(TensorType.Dimension::isIndexed).anyMatch(d -> d.size().isEmpty()) || this.type.dimensions().stream().filter(TensorType.Dimension::isMapped).count() > 1L) {
            return Tensor.toStandardString(this, withType, shortForms, maxCells);
        }
        return (String)(withType ? this.type + ":" : "") + this.index.contentToString(this, maxCells);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Tensor)) {
            return false;
        }
        return Tensor.equals(this, (Tensor)other);
    }

    public long denseSubspaceSize() {
        return this.denseSubspaceSize;
    }

    public static TensorType createPartialType(TensorType.Value valueType, List<TensorType.Dimension> dimensions) {
        TensorType.Builder builder = new TensorType.Builder(valueType);
        for (TensorType.Dimension dimension : dimensions) {
            builder.set(dimension);
        }
        return builder.build();
    }

    private static class Index {
        private final TensorType type;
        private final TensorType sparseType;
        private final TensorType denseType;
        private final List<TensorType.Dimension> mappedDimensions;
        private final List<TensorType.Dimension> indexedDimensions;
        private ImmutableMap<TensorAddress, Integer> sparseMap;
        private final int denseSubspaceSize;

        private static int computeDSS(List<TensorType.Dimension> dimensions) {
            long denseSubspaceSize = 1L;
            for (TensorType.Dimension dimension : dimensions) {
                denseSubspaceSize *= dimension.size().orElseThrow(() -> new IllegalArgumentException("Unknown size of indexed dimension")).longValue();
            }
            return (int)denseSubspaceSize;
        }

        private Index(TensorType type) {
            this.type = type;
            this.mappedDimensions = type.dimensions().stream().filter(d -> !d.isIndexed()).toList();
            this.indexedDimensions = type.dimensions().stream().filter(TensorType.Dimension::isIndexed).toList();
            this.sparseType = MixedTensor.createPartialType(type.valueType(), this.mappedDimensions);
            this.denseType = MixedTensor.createPartialType(type.valueType(), this.indexedDimensions);
            this.denseSubspaceSize = Index.computeDSS(this.indexedDimensions);
        }

        int blockIndexOf(TensorAddress address) {
            TensorAddress sparsePart = this.sparsePartialAddress(address);
            return (Integer)this.sparseMap.getOrDefault((Object)sparsePart, (Object)-1);
        }

        int denseOffsetOf(TensorAddress address) {
            long innerSize = 1L;
            long offset = 0L;
            int i = this.type.dimensions().size();
            while (--i >= 0) {
                TensorType.Dimension dimension = this.type.dimensions().get(i);
                if (!dimension.isIndexed()) continue;
                long label = address.numericLabel(i);
                offset += label * innerSize;
                innerSize *= dimension.size().orElseThrow(() -> new IllegalArgumentException("Unknown size of indexed dimension.")).longValue();
            }
            return (int)offset;
        }

        public int denseSubspaceSize() {
            return this.denseSubspaceSize;
        }

        private TensorAddress sparsePartialAddress(TensorAddress address) {
            if (this.type.dimensions().size() != address.size()) {
                throw new IllegalArgumentException("Tensor type of " + this + " is not the same size as " + address);
            }
            TensorAddress.Builder builder = new TensorAddress.Builder(this.sparseType);
            for (int i = 0; i < this.type.dimensions().size(); ++i) {
                TensorType.Dimension dimension = this.type.dimensions().get(i);
                if (dimension.isIndexed()) continue;
                builder.add(dimension.name(), address.label(i));
            }
            return builder.build();
        }

        private TensorAddress denseOffsetToAddress(long denseOffset) {
            if (denseOffset < 0L || denseOffset > (long)this.denseSubspaceSize) {
                throw new IllegalArgumentException("Offset out of bounds");
            }
            long restSize = denseOffset;
            long innerSize = this.denseSubspaceSize;
            long[] labels = new long[this.indexedDimensions.size()];
            for (int i = 0; i < labels.length; ++i) {
                TensorType.Dimension dimension = this.indexedDimensions.get(i);
                long dimensionSize = dimension.size().orElseThrow(() -> new IllegalArgumentException("Unknown size of indexed dimension."));
                labels[i] = restSize / (innerSize /= dimensionSize);
                restSize %= innerSize;
            }
            return TensorAddress.of(labels);
        }

        TensorAddress fullAddressOf(TensorAddress sparsePart, long denseOffset) {
            TensorAddress densePart = this.denseOffsetToAddress(denseOffset);
            String[] labels = new String[this.type.dimensions().size()];
            int mappedIndex = 0;
            int indexedIndex = 0;
            for (TensorType.Dimension d : this.type.dimensions()) {
                if (d.isIndexed()) {
                    labels[mappedIndex + indexedIndex] = densePart.label(indexedIndex);
                    ++indexedIndex;
                    continue;
                }
                labels[mappedIndex + indexedIndex] = sparsePart.label(mappedIndex);
                ++mappedIndex;
            }
            return TensorAddress.of(labels);
        }

        public String toString() {
            return "index into " + this.type;
        }

        private String contentToString(MixedTensor tensor, long maxCells) {
            if (this.mappedDimensions.size() > 1) {
                throw new IllegalStateException("Should be ensured by caller");
            }
            if (this.mappedDimensions.size() == 0) {
                StringBuilder b = new StringBuilder();
                int cellsWritten = this.denseSubspaceToString(tensor, 0, maxCells, b);
                if ((long)cellsWritten == maxCells && (long)cellsWritten < tensor.size()) {
                    b.append("...]");
                }
                return b.toString();
            }
            StringBuilder b = new StringBuilder("{");
            ArrayList cellEntries = new ArrayList(this.sparseMap.entrySet());
            cellEntries.sort(Map.Entry.comparingByKey());
            int cellsWritten = 0;
            for (int index = 0; index < cellEntries.size() && (long)cellsWritten < maxCells; ++index) {
                if (index > 0) {
                    b.append(", ");
                }
                b.append(TensorAddress.labelToString(((TensorAddress)((Map.Entry)cellEntries.get(index)).getKey()).label(0)));
                b.append(":");
                cellsWritten += this.denseSubspaceToString(tensor, (Integer)((Map.Entry)cellEntries.get(index)).getValue(), maxCells - (long)cellsWritten, b);
            }
            if ((long)cellsWritten >= maxCells && (long)cellsWritten < tensor.size()) {
                b.append(", ...");
            }
            b.append("}");
            return b.toString();
        }

        private int denseSubspaceToString(MixedTensor tensor, int subspaceIndex, long maxCells, StringBuilder b) {
            int index;
            if (maxCells <= 0L) {
                return 0;
            }
            if (this.denseSubspaceSize == 1) {
                b.append(this.getDouble(subspaceIndex, 0, tensor));
                return 1;
            }
            IndexedTensor.Indexes indexes = IndexedTensor.Indexes.of(this.denseType);
            for (index = 0; index < this.denseSubspaceSize && (long)index < maxCells; ++index) {
                int i;
                indexes.next();
                if (index > 0) {
                    b.append(", ");
                }
                for (i = 0; i < indexes.nextDimensionsAtStart(); ++i) {
                    b.append("[");
                }
                switch (this.type.valueType()) {
                    case DOUBLE: {
                        b.append(this.getDouble(subspaceIndex, index, tensor));
                        break;
                    }
                    case FLOAT: {
                        b.append(this.getDouble(subspaceIndex, index, tensor));
                        break;
                    }
                    case BFLOAT16: {
                        b.append(this.getDouble(subspaceIndex, index, tensor));
                        break;
                    }
                    case INT8: {
                        b.append(this.getDouble(subspaceIndex, index, tensor));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value type " + this.type.valueType());
                    }
                }
                for (i = 0; i < indexes.nextDimensionsAtEnd(); ++i) {
                    b.append("]");
                }
            }
            return index;
        }

        private double getDouble(int subspaceIndex, int denseOffset, MixedTensor tensor) {
            return tensor.denseSubspaces.get((int)subspaceIndex).cells[denseOffset];
        }

        static class Builder {
            private final Index index;
            private final ImmutableMap.Builder<TensorAddress, Integer> builder;

            Builder(TensorType type) {
                this.index = new Index(type);
                this.builder = new ImmutableMap.Builder();
            }

            void addBlock(TensorAddress address, int sz) {
                this.builder.put((Object)address, (Object)sz);
            }

            Index build() {
                this.index.sparseMap = this.builder.build();
                return this.index;
            }

            Index index() {
                return this.index;
            }
        }
    }

    public static final class DenseSubspace {
        public final TensorAddress sparseAddress;
        public final double[] cells;

        DenseSubspace(TensorAddress sparseAddress, double[] cells) {
            this.sparseAddress = sparseAddress;
            this.cells = cells;
        }

        public int hashCode() {
            return Objects.hash(this.sparseAddress, this.cells[0]);
        }

        public boolean equals(Object other) {
            if (other instanceof DenseSubspace) {
                DenseSubspace o = (DenseSubspace)other;
                return this.sparseAddress.equals(o.sparseAddress) && Arrays.equals(this.cells, o.cells);
            }
            return false;
        }
    }

    private static class DenseSubspaceBuilder
    implements IndexedTensor.DirectIndexBuilder {
        private final TensorType type;
        private final double[] values;

        public DenseSubspaceBuilder(TensorType type, double[] values) {
            this.type = type;
            this.values = values;
        }

        @Override
        public TensorType type() {
            return this.type;
        }

        @Override
        public void cellByDirectIndex(long index, double value) {
            this.values[(int)index] = value;
        }

        @Override
        public void cellByDirectIndex(long index, float value) {
            this.values[(int)index] = value;
        }
    }

    private static class UnboundBuilder
    extends Builder {
        private final Map<TensorAddress, Double> cells = new HashMap<TensorAddress, Double>();
        private final long[] dimensionBounds;

        private UnboundBuilder(TensorType type) {
            super(type);
            this.dimensionBounds = new long[type.dimensions().size()];
        }

        @Override
        public Tensor.Builder cell(TensorAddress address, float value) {
            return this.cell(address, (double)value);
        }

        @Override
        public Tensor.Builder cell(TensorAddress address, double value) {
            this.cells.put(address, value);
            this.trackBounds(address);
            return this;
        }

        @Override
        public MixedTensor build() {
            TensorType boundType = this.createBoundType();
            BoundBuilder builder = new BoundBuilder(boundType);
            for (Map.Entry<TensorAddress, Double> cell : this.cells.entrySet()) {
                builder.cell(cell.getKey(), (double)cell.getValue());
            }
            return builder.build();
        }

        private void trackBounds(TensorAddress address) {
            for (int i = 0; i < this.type.dimensions().size(); ++i) {
                TensorType.Dimension dimension = this.type.dimensions().get(i);
                if (!dimension.isIndexed()) continue;
                this.dimensionBounds[i] = Math.max(address.numericLabel(i), this.dimensionBounds[i]);
            }
        }

        private TensorType createBoundType() {
            TensorType.Builder typeBuilder = new TensorType.Builder(this.type().valueType());
            for (int i = 0; i < this.type.dimensions().size(); ++i) {
                TensorType.Dimension dimension = this.type.dimensions().get(i);
                if (!dimension.isIndexed()) {
                    typeBuilder.mapped(dimension.name());
                    continue;
                }
                long size = dimension.size().orElse(this.dimensionBounds[i] + 1L);
                typeBuilder.indexed(dimension.name(), size);
            }
            return typeBuilder.build();
        }

        public static UnboundBuilder of(TensorType type) {
            return new UnboundBuilder(type);
        }
    }

    public static class BoundBuilder
    extends Builder {
        private final Map<TensorAddress, double[]> denseSubspaceMap = new HashMap<TensorAddress, double[]>();
        private final Index.Builder indexBuilder;
        private final Index index;
        private final TensorType denseSubtype;

        private BoundBuilder(TensorType type) {
            super(type);
            this.indexBuilder = new Index.Builder(type);
            this.index = this.indexBuilder.index();
            this.denseSubtype = new TensorType(type.valueType(), type.dimensions().stream().filter(TensorType.Dimension::isIndexed).toList());
        }

        public long denseSubspaceSize() {
            return this.index.denseSubspaceSize();
        }

        private double[] denseSubspace(TensorAddress sparseAddress) {
            if (!this.denseSubspaceMap.containsKey(sparseAddress)) {
                this.denseSubspaceMap.put(sparseAddress, new double[(int)this.denseSubspaceSize()]);
            }
            return this.denseSubspaceMap.get(sparseAddress);
        }

        public IndexedTensor.DirectIndexBuilder denseSubspaceBuilder(TensorAddress sparseAddress) {
            double[] values = new double[(int)this.denseSubspaceSize()];
            this.denseSubspaceMap.put(sparseAddress, values);
            return new DenseSubspaceBuilder(this.denseSubtype, values);
        }

        @Override
        public Tensor.Builder cell(TensorAddress address, float value) {
            return this.cell(address, (double)value);
        }

        @Override
        public Tensor.Builder cell(TensorAddress address, double value) {
            TensorAddress sparsePart = this.index.sparsePartialAddress(address);
            int denseOffset = this.index.denseOffsetOf(address);
            double[] denseSubspace = this.denseSubspace(sparsePart);
            denseSubspace[denseOffset] = value;
            return this;
        }

        public Tensor.Builder block(TensorAddress sparsePart, double[] values) {
            int denseSubspaceSize = (int)this.denseSubspaceSize();
            if (values.length < denseSubspaceSize) {
                throw new IllegalArgumentException("Block should have " + denseSubspaceSize + " values, but has only " + values.length);
            }
            double[] denseSubspace = this.denseSubspace(sparsePart);
            System.arraycopy(values, 0, denseSubspace, 0, denseSubspaceSize);
            return this;
        }

        @Override
        public MixedTensor build() {
            ArrayList<DenseSubspace> list = new ArrayList<DenseSubspace>();
            for (Map.Entry<TensorAddress, double[]> entry : this.denseSubspaceMap.entrySet()) {
                TensorAddress sparsePart = entry.getKey();
                double[] denseSubspace = entry.getValue();
                DenseSubspace block = new DenseSubspace(sparsePart, denseSubspace);
                this.indexBuilder.addBlock(sparsePart, list.size());
                list.add(block);
            }
            return new MixedTensor(this.type, list, this.indexBuilder.build());
        }

        public static BoundBuilder of(TensorType type) {
            return new BoundBuilder(type);
        }
    }

    public static abstract class Builder
    implements Tensor.Builder {
        final TensorType type;

        public static Builder of(TensorType type) {
            if (type.dimensions().stream().anyMatch(d -> d instanceof TensorType.IndexedUnboundDimension)) {
                return new UnboundBuilder(type);
            }
            return new BoundBuilder(type);
        }

        private Builder(TensorType type) {
            this.type = type;
        }

        @Override
        public TensorType type() {
            return this.type;
        }

        @Override
        public Tensor.Builder cell(float value, long ... labels) {
            return this.cell((double)value, labels);
        }

        @Override
        public Tensor.Builder cell(double value, long ... labels) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public Tensor.Builder.CellBuilder cell() {
            return new Tensor.Builder.CellBuilder(this.type(), this);
        }

        @Override
        public abstract MixedTensor build();
    }
}

