/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.text;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XML {
    private static final Scan scanner = new Scan();

    public static String xmlEscape(String string) {
        return XML.xmlEscape(string, true, true, null, -1);
    }

    public static String xmlEscape(String string, boolean isAttribute) {
        return XML.xmlEscape(string, isAttribute, true, null, -1);
    }

    public static String xmlEscape(String string, boolean isAttribute, char stripCharacter) {
        return XML.xmlEscape(string, isAttribute, true, null, stripCharacter);
    }

    public static String xmlEscape(String string, boolean isAttribute, boolean escapeLowAscii) {
        return XML.xmlEscape(string, isAttribute, escapeLowAscii, null, -1);
    }

    public static String xmlEscape(String string, boolean isAttribute, boolean escapeLowAscii, char stripCharacter) {
        return XML.xmlEscape(string, isAttribute, escapeLowAscii, null, stripCharacter);
    }

    public static String xmlEscape(String string, boolean isAttribute, StringBuilder buffer) {
        return XML.xmlEscape(string, isAttribute, true, buffer, -1);
    }

    public static String xmlEscape(String string, boolean isAttribute, boolean escapeLowAscii, StringBuilder buffer) {
        return XML.xmlEscape(string, isAttribute, escapeLowAscii, buffer, -1);
    }

    public static String xmlEscape(String string, boolean isAttribute, boolean escapeLowAscii, StringBuilder buffer, int stripCodePoint) {
        boolean legalCharacter = true;
        int i = 0;
        i = 0;
        while (i < string.length() && legalCharacter) {
            legalCharacter = scanner.isLegal(string.codePointAt(i), escapeLowAscii, stripCodePoint, isAttribute);
            i = string.offsetByCodePoints(i, 1);
        }
        if (legalCharacter) {
            return string;
        }
        i = string.offsetByCodePoints(i, -1);
        Quote escaper = new Quote();
        if (buffer == null) {
            buffer = new StringBuilder((int)((double)string.length() * 1.2));
        }
        if (i > 0) {
            buffer.append(string.substring(0, i));
        }
        while (i < string.length()) {
            int codepoint = string.codePointAt(i);
            if (escaper.isLegal(codepoint, escapeLowAscii, stripCodePoint, isAttribute)) {
                buffer.appendCodePoint(codepoint);
            } else {
                buffer.append(escaper.lastQuoted);
            }
            i = string.offsetByCodePoints(i, 1);
        }
        return buffer.toString();
    }

    public static Document getDocument(File xmlFile) {
        try {
            return XML.getDocumentBuilder().parse(xmlFile);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read '" + xmlFile + "'", e);
        }
        catch (SAXParseException e) {
            throw new IllegalArgumentException("Could not parse '" + xmlFile + "', error at line " + e.getLineNumber() + ", column " + e.getColumnNumber(), e);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("Could not parse '" + xmlFile + "'", e);
        }
    }

    public static Document getDocument(Reader reader) {
        try {
            return XML.getDocumentBuilder().parse(new InputSource(reader));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read '" + reader + "'", e);
        }
        catch (SAXParseException e) {
            throw new IllegalArgumentException("Could not parse '" + reader + "', error at line " + e.getLineNumber() + ", column " + e.getColumnNumber(), e);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("Could not parse '" + reader + "'", e);
        }
    }

    public static Document getDocument(String xmlString) {
        return XML.getDocument(new StringReader(xmlString));
    }

    public static DocumentBuilder getDocumentBuilder() {
        return XML.getDocumentBuilder("com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl", null, true);
    }

    public static DocumentBuilder getDocumentBuilder(String implementation, ClassLoader classLoader) {
        return XML.getDocumentBuilder(true);
    }

    public static DocumentBuilder getDocumentBuilder(boolean namespaceAware) {
        return XML.getDocumentBuilder("com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl", null, namespaceAware);
    }

    public static DocumentBuilder getDocumentBuilder(String implementation, ClassLoader classLoader, boolean namespaceAware) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance(implementation, classLoader);
            factory.setNamespaceAware(namespaceAware);
            factory.setXIncludeAware(false);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Could not create an XML builder", e);
        }
    }

    public static List<Element> getChildren(Element spec) {
        ArrayList<Element> children = new ArrayList<Element>();
        if (spec == null) {
            return children;
        }
        NodeList childNodes = spec.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (!(child instanceof Element)) continue;
            children.add((Element)child);
        }
        return children;
    }

    public static List<Element> getChildren(Element spec, String name) {
        ArrayList<Element> ret = new ArrayList<Element>();
        if (spec == null) {
            return ret;
        }
        NodeList children = spec.getChildNodes();
        if (children == null) {
            return ret;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || !(child instanceof Element) || !child.getNodeName().equals(name)) continue;
            ret.add((Element)child);
        }
        return ret;
    }

    public static Optional<String> attribute(String name, Element element) {
        if (!element.hasAttribute(name)) {
            return Optional.empty();
        }
        return Optional.of(element.getAttribute(name));
    }

    public static String getValue(Element e) {
        if (e == null) {
            return "";
        }
        Node child = e.getFirstChild();
        if (child == null) {
            return "";
        }
        if (child.getNodeValue() == null) {
            return "";
        }
        return child.getNodeValue();
    }

    public static Element getChild(Element e, String name) {
        return XML.getChildren(e, name).size() >= 1 ? XML.getChildren(e, name).get(0) : null;
    }

    public static Optional<String> getChildValue(Element e, String name) {
        Element child = XML.getChild(e, name);
        if (child == null) {
            return Optional.empty();
        }
        return Optional.of(XML.getValue(child));
    }

    public static String getNodePath(Node n, String sep) {
        if (n == null) {
            return "";
        }
        StringBuffer ret = new StringBuffer(n.getNodeName());
        while (n.getParentNode() != null && !(n.getParentNode() instanceof Document)) {
            n = n.getParentNode();
            ret.insert(0, sep).insert(0, n.getNodeName());
        }
        return ret.toString();
    }

    private static boolean inclusiveWithin(int x, int low, int high) {
        return low <= x && x <= high;
    }

    private static boolean nameStartSet(int codepoint) {
        boolean valid = codepoint < 192 ? XML.inclusiveWithin(codepoint, 97, 122) || XML.inclusiveWithin(codepoint, 65, 90) || codepoint == 95 || codepoint == 58 : XML.inclusiveWithin(codepoint, 192, 214) || XML.inclusiveWithin(codepoint, 216, 246) || XML.inclusiveWithin(codepoint, 248, 767) || XML.inclusiveWithin(codepoint, 880, 893) || XML.inclusiveWithin(codepoint, 895, 8191) || XML.inclusiveWithin(codepoint, 8204, 8205) || XML.inclusiveWithin(codepoint, 8304, 8591) || XML.inclusiveWithin(codepoint, 11264, 12271) || XML.inclusiveWithin(codepoint, 12289, 55295) || XML.inclusiveWithin(codepoint, 63744, 64975) || XML.inclusiveWithin(codepoint, 65008, 65533) || XML.inclusiveWithin(codepoint, 65536, 983039);
        return valid;
    }

    private static boolean nameSetExceptStart(int codepoint) {
        boolean valid = codepoint < 183 ? XML.inclusiveWithin(codepoint, 48, 57) || codepoint == 45 || codepoint == 46 : codepoint == 183 || XML.inclusiveWithin(codepoint, 768, 879) || XML.inclusiveWithin(codepoint, 575, 8256);
        return valid;
    }

    private static boolean nameChar(int codepoint, boolean first) {
        boolean valid = XML.nameStartSet(codepoint);
        return first ? valid : valid || XML.nameSetExceptStart(codepoint);
    }

    public static boolean isName(CharSequence possibleName) {
        int barrier = possibleName.length();
        int i = 0;
        boolean valid = true;
        boolean first = true;
        if (barrier < 1) {
            valid = false;
        }
        while (valid && i < barrier) {
            char c;
            valid = Character.isHighSurrogate(c = possibleName.charAt(i++)) ? XML.nameChar(Character.toCodePoint(c, possibleName.charAt(i++)), first) : XML.nameChar(c, first);
            first = false;
        }
        return valid;
    }

    private static final class Scan
    extends LegalCharacters {
        private Scan() {
        }

        @Override
        protected void quoteQuot() {
        }

        @Override
        protected void quoteGt() {
        }

        @Override
        protected void quoteLt() {
        }

        @Override
        protected void quoteAmp() {
        }

        @Override
        protected void remove() {
        }

        @Override
        protected void ctrlEscape(int codepoint) {
        }

        @Override
        protected void replace(int codepoint) {
        }
    }

    private static final class Quote
    extends LegalCharacters {
        char[] lastQuoted;
        private static final char[] EMPTY = new char[0];
        private static final char[] REPLACEMENT_CHARACTER = "\ufffd".toCharArray();
        private static final char[] AMP = "&amp;".toCharArray();
        private static final char[] LT = "&lt;".toCharArray();
        private static final char[] GT = "&gt;".toCharArray();
        private static final char[] QUOT = "&quot;".toCharArray();

        private Quote() {
        }

        @Override
        protected void remove() {
            this.lastQuoted = EMPTY;
        }

        @Override
        protected void replace(int codepoint) {
            this.lastQuoted = REPLACEMENT_CHARACTER;
        }

        @Override
        protected void quoteQuot() {
            this.lastQuoted = QUOT;
        }

        @Override
        protected void quoteGt() {
            this.lastQuoted = GT;
        }

        @Override
        protected void quoteLt() {
            this.lastQuoted = LT;
        }

        @Override
        protected void quoteAmp() {
            this.lastQuoted = AMP;
        }

        @Override
        protected void ctrlEscape(int codepoint) {
            this.lastQuoted = REPLACEMENT_CHARACTER;
        }
    }

    private static abstract class LegalCharacters {
        private LegalCharacters() {
        }

        final boolean isLegal(int codepoint, boolean escapeLow, int stripCodePoint, boolean isAttribute) {
            if (codepoint == stripCodePoint) {
                return this.removeCodePoint();
            }
            if (codepoint < 32) {
                if (!escapeLow) {
                    return true;
                }
                switch (codepoint) {
                    case 9: 
                    case 10: 
                    case 13: {
                        return true;
                    }
                }
                return this.ctrlEscapeCodePoint(codepoint);
            }
            if (codepoint >= 32 && codepoint <= 55295) {
                switch (codepoint) {
                    case 38: {
                        return this.ampCodePoint();
                    }
                    case 60: {
                        return this.ltCodePoint();
                    }
                    case 62: {
                        return this.gtCodePoint();
                    }
                    case 34: {
                        return this.quotCodePoint(isAttribute);
                    }
                }
                return true;
            }
            if (codepoint >= 57344 && codepoint <= 65533 || codepoint >= 65536 && codepoint <= 0x10FFFF) {
                return true;
            }
            return this.filterCodePoint(codepoint);
        }

        private boolean quotCodePoint(boolean isAttribute) {
            if (isAttribute) {
                this.quoteQuot();
                return false;
            }
            return true;
        }

        private boolean filterCodePoint(int codepoint) {
            this.replace(codepoint);
            return false;
        }

        private boolean gtCodePoint() {
            this.quoteGt();
            return false;
        }

        private boolean ltCodePoint() {
            this.quoteLt();
            return false;
        }

        private boolean ampCodePoint() {
            this.quoteAmp();
            return false;
        }

        private boolean ctrlEscapeCodePoint(int codepoint) {
            this.ctrlEscape(codepoint);
            return false;
        }

        private boolean removeCodePoint() {
            this.remove();
            return false;
        }

        protected abstract void quoteQuot();

        protected abstract void quoteGt();

        protected abstract void quoteLt();

        protected abstract void quoteAmp();

        protected abstract void remove();

        protected abstract void ctrlEscape(int var1);

        protected abstract void replace(int var1);
    }
}

