/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.llm.client.openai;

import ai.vespa.llm.LanguageModel;
import ai.vespa.llm.completion.Completion;
import ai.vespa.llm.completion.Prompt;
import com.yahoo.api.annotations.Beta;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;

@Beta
public class OpenAiClient
implements LanguageModel {
    private final String token;
    private final String model;
    private final double temperature;
    private final HttpClient httpClient;

    private OpenAiClient(Builder builder) {
        this.token = builder.token;
        this.model = builder.model;
        this.temperature = builder.temperature;
        this.httpClient = HttpClient.newBuilder().build();
    }

    @Override
    public List<Completion> complete(Prompt prompt) {
        try {
            HttpResponse<byte[]> httpResponse = this.httpClient.send(this.toRequest(prompt), HttpResponse.BodyHandlers.ofByteArray());
            Cursor response = SlimeUtils.jsonToSlime(httpResponse.body()).get();
            if (httpResponse.statusCode() != 200) {
                throw new IllegalArgumentException(SlimeUtils.toJson(response));
            }
            return this.toCompletions(response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private HttpRequest toRequest(Prompt prompt) throws IOException, URISyntaxException {
        Slime slime = new Slime();
        Cursor root = slime.setObject();
        root.setString("model", this.model);
        root.setDouble("temperature", this.temperature);
        root.setString("prompt", prompt.asString());
        return HttpRequest.newBuilder(new URI("https://api.openai.com/v1/completions")).header("Content-Type", "application/json").header("Authorization", "Bearer " + this.token).POST(HttpRequest.BodyPublishers.ofByteArray(SlimeUtils.toJsonBytes(slime))).build();
    }

    private List<Completion> toCompletions(Inspector response) {
        ArrayList<Completion> completions = new ArrayList<Completion>();
        response.field("choices").traverse((__, choice) -> completions.add(this.toCompletion(choice)));
        return completions;
    }

    private Completion toCompletion(Inspector choice) {
        return new Completion(choice.field("text").asString(), this.toFinishReason(choice.field("finish_reason").asString()));
    }

    private Completion.FinishReason toFinishReason(String finishReasonString) {
        return switch (finishReasonString) {
            case "length" -> Completion.FinishReason.length;
            case "stop" -> Completion.FinishReason.stop;
            default -> throw new IllegalStateException("Unknown OpenAi completion finish reason '" + finishReasonString + "'");
        };
    }

    public static class Builder {
        private final String token;
        private String model = "text-davinci-003";
        private double temperature = 0.0;

        public Builder(String token) {
            this.token = token;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder temperature(double temperature) {
            this.temperature = temperature;
            return this;
        }

        public OpenAiClient build() {
            return new OpenAiClient(this);
        }
    }
}

