/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.slime;

import com.yahoo.slime.ArrayTraverser;
import com.yahoo.slime.BinaryDecoder;
import com.yahoo.slime.BinaryFormat;
import com.yahoo.slime.BufferedInput;
import com.yahoo.slime.DecodeIndex;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.NixValue;
import com.yahoo.slime.ObjectSymbolTraverser;
import com.yahoo.slime.ObjectTraverser;
import com.yahoo.slime.SymbolTable;
import com.yahoo.slime.Type;
import com.yahoo.slime.Utf8Codec;
import com.yahoo.slime.Value;
import com.yahoo.slime.Visitor;
import java.util.function.Consumer;

public final class BinaryView
implements Inspector {
    private final byte[] data;
    private final SymbolTable names;
    private final DecodeIndex index;
    private final int self;

    private BinaryView(byte[] data, SymbolTable names, DecodeIndex index, int self) {
        this.data = data;
        this.names = names;
        this.index = index;
        this.self = self;
    }

    private int peek_cmpr_int(int idx) {
        long next = this.data[idx++];
        long value = next & 0x7FL;
        int shift = 7;
        while ((next & 0x80L) != 0L) {
            next = this.data[idx++];
            value |= (next & 0x7FL) << shift;
            shift += 7;
        }
        return (int)value;
    }

    private int skip_cmpr_int(int idx) {
        while ((this.data[idx++] & 0x80) != 0) {
        }
        return idx;
    }

    private int extract_children(int idx) {
        int bytes;
        return (bytes = BinaryFormat.decode_meta(this.data[idx++])) == 0 ? this.peek_cmpr_int(idx) : bytes - 1;
    }

    private long extract_long(int idx) {
        int bytes = BinaryFormat.decode_meta(this.data[idx++]);
        long value = 0L;
        int shift = 0;
        for (int i = 0; i < bytes; ++i) {
            long b = this.data[idx++];
            value |= (b & 0xFFL) << shift;
            shift += 8;
        }
        return BinaryFormat.decode_zigzag(value);
    }

    private double extract_double(int idx) {
        int bytes = BinaryFormat.decode_meta(this.data[idx++]);
        long value = 0L;
        int shift = 56;
        for (int i = 0; i < bytes; ++i) {
            long b = this.data[idx++];
            value |= (b & 0xFFL) << shift;
            shift -= 8;
        }
        return BinaryFormat.decode_double(value);
    }

    private String extract_string(int idx) {
        int bytes;
        if ((bytes = BinaryFormat.decode_meta(this.data[idx++])) == 0) {
            bytes = this.peek_cmpr_int(idx);
            idx = this.skip_cmpr_int(idx);
        } else {
            --bytes;
        }
        return Utf8Codec.decode(this.data, idx, bytes);
    }

    private byte[] extract_bytes(int idx) {
        int bytes;
        if ((bytes = BinaryFormat.decode_meta(this.data[idx++])) == 0) {
            bytes = this.peek_cmpr_int(idx);
            idx = this.skip_cmpr_int(idx);
        } else {
            --bytes;
        }
        byte[] ret = new byte[bytes];
        for (int i = 0; i < bytes; ++i) {
            ret[i] = this.data[idx++];
        }
        return ret;
    }

    private Inspector find_field(int pos, int len, int sym) {
        for (int i = 0; i < len; ++i) {
            int idx = this.index.getByteOffset(pos + i);
            if (this.peek_cmpr_int(idx - (this.index.getExtBits(pos + i) + 1)) != sym) continue;
            return new BinaryView(this.data, this.names, this.index, pos + i);
        }
        return NixValue.invalid();
    }

    @Override
    public boolean valid() {
        return true;
    }

    @Override
    public void ifValid(Consumer<Inspector> consumer) {
        consumer.accept(this);
    }

    @Override
    public Type type() {
        return BinaryFormat.decode_type(this.data[this.index.getByteOffset(this.self)]);
    }

    @Override
    public int children() {
        return switch (this.type()) {
            case Type.OBJECT, Type.ARRAY -> this.extract_children(this.index.getByteOffset(this.self));
            default -> 0;
        };
    }

    @Override
    public int entries() {
        return switch (this.type()) {
            case Type.ARRAY -> this.extract_children(this.index.getByteOffset(this.self));
            default -> 0;
        };
    }

    @Override
    public int fields() {
        return switch (this.type()) {
            case Type.OBJECT -> this.extract_children(this.index.getByteOffset(this.self));
            default -> 0;
        };
    }

    @Override
    public boolean asBool() {
        return switch (this.type()) {
            case Type.BOOL -> {
                if (BinaryFormat.decode_meta(this.data[this.index.getByteOffset(this.self)]) != 0) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    public long asLong() {
        return switch (this.type()) {
            case Type.LONG -> this.extract_long(this.index.getByteOffset(this.self));
            case Type.DOUBLE -> (long)this.extract_double(this.index.getByteOffset(this.self));
            default -> 0L;
        };
    }

    @Override
    public double asDouble() {
        return switch (this.type()) {
            case Type.LONG -> this.extract_long(this.index.getByteOffset(this.self));
            case Type.DOUBLE -> this.extract_double(this.index.getByteOffset(this.self));
            default -> 0.0;
        };
    }

    @Override
    public String asString() {
        return switch (this.type()) {
            case Type.STRING -> this.extract_string(this.index.getByteOffset(this.self));
            default -> "";
        };
    }

    @Override
    public byte[] asUtf8() {
        return switch (this.type()) {
            case Type.STRING -> this.extract_bytes(this.index.getByteOffset(this.self));
            default -> Value.emptyData;
        };
    }

    @Override
    public byte[] asData() {
        return switch (this.type()) {
            case Type.DATA -> this.extract_bytes(this.index.getByteOffset(this.self));
            default -> Value.emptyData;
        };
    }

    @Override
    public void accept(Visitor v) {
        switch (this.type()) {
            case NIX: {
                v.visitNix();
                break;
            }
            case BOOL: {
                v.visitBool(BinaryFormat.decode_meta(this.data[this.index.getByteOffset(this.self)]) != 0);
                break;
            }
            case LONG: {
                v.visitLong(this.extract_long(this.index.getByteOffset(this.self)));
                break;
            }
            case DOUBLE: {
                v.visitDouble(this.extract_double(this.index.getByteOffset(this.self)));
                break;
            }
            case STRING: {
                v.visitString(this.extract_bytes(this.index.getByteOffset(this.self)));
                break;
            }
            case DATA: {
                v.visitData(this.extract_bytes(this.index.getByteOffset(this.self)));
                break;
            }
            case ARRAY: {
                v.visitArray(this);
                break;
            }
            case OBJECT: {
                v.visitObject(this);
                break;
            }
            default: {
                throw new RuntimeException("should not be reached");
            }
        }
    }

    @Override
    public void traverse(ArrayTraverser at) {
        int pos = this.index.getFirstChild(this.self);
        int len = this.entries();
        for (int i = 0; i < len; ++i) {
            at.entry(i, new BinaryView(this.data, this.names, this.index, pos + i));
        }
    }

    @Override
    public void traverse(ObjectSymbolTraverser ot) {
        int pos = this.index.getFirstChild(this.self);
        int len = this.fields();
        for (int i = 0; i < len; ++i) {
            int sym = this.peek_cmpr_int(this.index.getByteOffset(pos + i) - (this.index.getExtBits(pos + i) + 1));
            ot.field(sym, new BinaryView(this.data, this.names, this.index, pos + i));
        }
    }

    @Override
    public void traverse(ObjectTraverser ot) {
        int pos = this.index.getFirstChild(this.self);
        int len = this.fields();
        for (int i = 0; i < len; ++i) {
            int sym = this.peek_cmpr_int(this.index.getByteOffset(pos + i) - (this.index.getExtBits(pos + i) + 1));
            ot.field(this.names.inspect(sym), new BinaryView(this.data, this.names, this.index, pos + i));
        }
    }

    @Override
    public Inspector entry(int idx) {
        int limit = this.entries();
        if (idx >= 0 && idx < limit) {
            return new BinaryView(this.data, this.names, this.index, this.index.getFirstChild(this.self) + idx);
        }
        return NixValue.invalid();
    }

    @Override
    public Inspector field(int sym) {
        int limit = this.fields();
        if (limit > 0 && sym != Integer.MAX_VALUE) {
            return this.find_field(this.index.getFirstChild(this.self), limit, sym);
        }
        return NixValue.invalid();
    }

    @Override
    public Inspector field(String name) {
        int sym;
        int limit = this.fields();
        if (limit > 0 && (sym = this.names.lookup(name)) != Integer.MAX_VALUE) {
            return this.find_field(this.index.getFirstChild(this.self), limit, sym);
        }
        return NixValue.invalid();
    }

    private static void buildIndex(BufferedInput input, DecodeIndex index, int self, int extBits) {
        int pos = input.getPosition();
        byte tag = input.getByte();
        Type type = BinaryFormat.decode_type(tag);
        int meta = BinaryFormat.decode_meta(tag);
        switch (type) {
            case BOOL: 
            case NIX: {
                index.set(self, pos, 0, extBits);
                break;
            }
            case LONG: 
            case DOUBLE: {
                input.skip(meta);
                index.set(self, pos, 0, extBits);
                break;
            }
            case STRING: 
            case DATA: {
                int size = input.read_size(meta);
                input.skip(size);
                index.set(self, pos, 0, extBits);
                break;
            }
            case ARRAY: {
                int size = input.read_size(meta);
                if (size > input.getBacking().length - index.size()) {
                    input.fail("decode index too big");
                    return;
                }
                int firstChild = index.reserve(size);
                index.set(self, pos, firstChild, extBits);
                for (int i = 0; i < size; ++i) {
                    BinaryView.buildIndex(input, index, firstChild + i, 0);
                }
                break;
            }
            case OBJECT: {
                int size = input.read_size(meta);
                if (size > input.getBacking().length - index.size()) {
                    input.fail("decode index too big");
                    return;
                }
                int firstChild = index.reserve(size);
                index.set(self, pos, firstChild, extBits);
                for (int i = 0; i < size; ++i) {
                    int childExtBits = input.skip_cmpr_int();
                    if (childExtBits > 3) {
                        input.fail("symbol id too big");
                        return;
                    }
                    BinaryView.buildIndex(input, index, firstChild + i, childExtBits);
                }
                break;
            }
            default: {
                throw new RuntimeException("should not be reached");
            }
        }
    }

    static Inspector inspectImpl(BufferedInput input) {
        SymbolTable names = new SymbolTable();
        DecodeIndex index = new DecodeIndex();
        BinaryDecoder.decodeSymbolTable(input, names);
        BinaryView.buildIndex(input, index, index.reserve(1), 0);
        if (input.failed()) {
            return NixValue.invalid();
        }
        return new BinaryView(input.getBacking(), names, index, 0);
    }

    public static Inspector inspect(byte[] data) {
        return BinaryView.inspectImpl(new BufferedInput(data));
    }

    static int peek_cmpr_int_for_testing(byte[] data, int idx) {
        return new BinaryView(data, null, null, -1).peek_cmpr_int(idx);
    }

    static int skip_cmpr_int_for_testing(byte[] data, int idx) {
        return new BinaryView(data, null, null, -1).skip_cmpr_int(idx);
    }

    static int extract_children_for_testing(byte[] data, int idx) {
        return new BinaryView(data, null, null, -1).extract_children(idx);
    }

    static long extract_long_for_testing(byte[] data, int idx) {
        return new BinaryView(data, null, null, -1).extract_long(idx);
    }

    static double extract_double_for_testing(byte[] data, int idx) {
        return new BinaryView(data, null, null, -1).extract_double(idx);
    }
}

