/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.functions;

import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.Name;
import com.yahoo.tensor.functions.CompositeTensorFunction;
import com.yahoo.tensor.functions.Generate;
import com.yahoo.tensor.functions.PrimitiveTensorFunction;
import com.yahoo.tensor.functions.ScalarFunctions;
import com.yahoo.tensor.functions.TensorFunction;
import com.yahoo.tensor.functions.ToStringContext;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Diag<NAMETYPE extends Name>
extends CompositeTensorFunction<NAMETYPE> {
    private final TensorType type;
    private final Function<List<Long>, Double> diagFunction;

    public Diag(TensorType type) {
        this.type = type;
        this.diagFunction = ScalarFunctions.equal(this.dimensionNames().toList());
    }

    @Override
    public List<TensorFunction<NAMETYPE>> arguments() {
        return Collections.emptyList();
    }

    @Override
    public TensorFunction<NAMETYPE> withArguments(List<TensorFunction<NAMETYPE>> arguments) {
        if (arguments.size() != 0) {
            throw new IllegalArgumentException("Diag must have 0 arguments, got " + arguments.size());
        }
        return this;
    }

    @Override
    public PrimitiveTensorFunction<NAMETYPE> toPrimitive() {
        return new Generate(this.type, this.diagFunction);
    }

    private Stream<String> dimensionNames() {
        return this.type.dimensions().stream().map(TensorType.Dimension::name);
    }

    @Override
    public String toString(ToStringContext<NAMETYPE> context) {
        return "diag(" + this.dimensionNames().collect(Collectors.joining(",")) + ")" + this.diagFunction;
    }

    @Override
    public int hashCode() {
        return Objects.hash("diag", this.type, this.diagFunction);
    }
}

