/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor.evaluation;

import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.EvaluationContext;
import com.yahoo.tensor.evaluation.Name;
import com.yahoo.tensor.evaluation.TypeContext;
import com.yahoo.tensor.functions.PrimitiveTensorFunction;
import com.yahoo.tensor.functions.TensorFunction;
import com.yahoo.tensor.functions.ToStringContext;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class VariableTensor<NAMETYPE extends Name>
extends PrimitiveTensorFunction<NAMETYPE> {
    private final String name;
    private final Optional<TensorType> requiredType;

    public VariableTensor(String name) {
        this.name = name;
        this.requiredType = Optional.empty();
    }

    public VariableTensor(String name, TensorType requiredType) {
        this.name = name;
        this.requiredType = Optional.of(requiredType);
    }

    @Override
    public List<TensorFunction<NAMETYPE>> arguments() {
        return Collections.emptyList();
    }

    @Override
    public TensorFunction<NAMETYPE> withArguments(List<TensorFunction<NAMETYPE>> arguments) {
        return this;
    }

    @Override
    public PrimitiveTensorFunction<NAMETYPE> toPrimitive() {
        return this;
    }

    @Override
    public TensorType type(TypeContext<NAMETYPE> context) {
        TensorType givenType = context.getType(this.name);
        if (givenType == null) {
            return null;
        }
        this.verifyType(givenType);
        return givenType;
    }

    @Override
    public Tensor evaluate(EvaluationContext<NAMETYPE> context) {
        Tensor tensor = context.getTensor(this.name);
        if (tensor == null) {
            return null;
        }
        this.verifyType(tensor.type());
        return tensor;
    }

    @Override
    public String toString(ToStringContext<NAMETYPE> context) {
        return this.name;
    }

    @Override
    public int hashCode() {
        return Objects.hash("variableTensor", this.name, this.requiredType);
    }

    private void verifyType(TensorType givenType) {
        if (this.requiredType.isPresent() && !givenType.isAssignableTo(this.requiredType.get())) {
            throw new IllegalArgumentException("Variable '" + this.name + "' must be compatible with " + this.requiredType.get() + " but was " + givenType);
        }
    }
}

