/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.net;

public class UrlToken {
    private final Type type;
    private final int offset;
    private final String orig;
    private final String term;

    public UrlToken(Type type, int offset, String orig, String term) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.type = type;
        this.offset = offset;
        this.orig = orig;
        this.term = term;
    }

    public Type getType() {
        return this.type;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.orig != null ? this.orig.length() : 0;
    }

    public String getOrig() {
        return this.orig;
    }

    public String getTerm() {
        return this.term;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UrlToken)) {
            return false;
        }
        UrlToken rhs = (UrlToken)obj;
        if (this.offset != rhs.offset) {
            return false;
        }
        if (this.orig != null ? !this.orig.equals(rhs.orig) : rhs.orig != null) {
            return false;
        }
        if (this.term != null ? !this.term.equals(rhs.term) : rhs.term != null) {
            return false;
        }
        return this.type == rhs.type;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + this.offset;
        result = 31 * result + (this.orig != null ? this.orig.hashCode() : 0);
        result = 31 * result + (this.term != null ? this.term.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder("UrlToken(");
        ret.append("type=").append((Object)this.type).append(", ");
        ret.append("offset=").append(this.offset).append(", ");
        if (this.orig != null) {
            ret.append("orig='").append(this.orig).append("', ");
        }
        if (this.term != null) {
            ret.append("term='").append(this.term).append("', ");
        }
        ret.setLength(ret.length() - 2);
        ret.append(")");
        return ret.toString();
    }

    public static enum Type {
        SCHEME,
        USERINFO,
        PASSWORD,
        HOST,
        PORT,
        PATH,
        QUERY,
        FRAGMENT;

    }
}

