/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.slime;

import com.yahoo.slime.ArrayTraverser;
import com.yahoo.slime.BoolValue;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.DataValue;
import com.yahoo.slime.DoubleValue;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.JsonFormat;
import com.yahoo.slime.LongValue;
import com.yahoo.slime.NixValue;
import com.yahoo.slime.ObjectSymbolTraverser;
import com.yahoo.slime.ObjectTraverser;
import com.yahoo.slime.StringValue;
import com.yahoo.slime.Utf8Codec;
import com.yahoo.slime.Utf8Value;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;

abstract class Value
implements Cursor {
    private static final String emptyString = "";
    private static final byte[] emptyData = new byte[0];

    Value() {
    }

    @Override
    public final boolean valid() {
        return this != NixValue.invalid();
    }

    @Override
    public int children() {
        return 0;
    }

    @Override
    public int entries() {
        return 0;
    }

    @Override
    public int fields() {
        return 0;
    }

    @Override
    public boolean asBool() {
        return false;
    }

    @Override
    public long asLong() {
        return 0L;
    }

    @Override
    public double asDouble() {
        return 0.0;
    }

    @Override
    public String asString() {
        return emptyString;
    }

    @Override
    public byte[] asUtf8() {
        return emptyData;
    }

    @Override
    public byte[] asData() {
        return emptyData;
    }

    @Override
    public void traverse(ArrayTraverser at) {
    }

    @Override
    public void traverse(ObjectSymbolTraverser ot) {
    }

    @Override
    public void traverse(ObjectTraverser ot) {
    }

    @Override
    public Value entry(int idx) {
        return NixValue.invalid();
    }

    @Override
    public Value field(String name) {
        return NixValue.invalid();
    }

    @Override
    public Value field(int sym) {
        return NixValue.invalid();
    }

    protected Cursor addLeaf(Value value) {
        return NixValue.invalid();
    }

    @Override
    public Cursor addArray() {
        return NixValue.invalid();
    }

    @Override
    public Cursor addObject() {
        return NixValue.invalid();
    }

    @Override
    public final Cursor addNix() {
        return this.addLeaf(NixValue.instance());
    }

    @Override
    public final Cursor addBool(boolean bit) {
        return this.addLeaf(BoolValue.instance(bit));
    }

    @Override
    public final Cursor addLong(long l) {
        return this.addLeaf(new LongValue(l));
    }

    @Override
    public final Cursor addDouble(double d) {
        return this.addLeaf(new DoubleValue(d));
    }

    @Override
    public final Cursor addString(String str) {
        return this.addLeaf(StringValue.create(str));
    }

    @Override
    public final Cursor addString(byte[] utf8) {
        return this.addLeaf(Utf8Value.create(utf8));
    }

    @Override
    public final Cursor addData(byte[] data) {
        return this.addLeaf(DataValue.create(data));
    }

    protected Cursor setLeaf(int sym, Value value) {
        return NixValue.invalid();
    }

    @Override
    public Cursor setArray(int sym) {
        return NixValue.invalid();
    }

    @Override
    public Cursor setObject(int sym) {
        return NixValue.invalid();
    }

    @Override
    public final Cursor setNix(int sym) {
        return this.setLeaf(sym, (Value)NixValue.instance());
    }

    @Override
    public final Cursor setBool(int sym, boolean bit) {
        return this.setLeaf(sym, (Value)BoolValue.instance(bit));
    }

    @Override
    public final Cursor setLong(int sym, long l) {
        return this.setLeaf(sym, (Value)new LongValue(l));
    }

    @Override
    public final Cursor setDouble(int sym, double d) {
        return this.setLeaf(sym, (Value)new DoubleValue(d));
    }

    @Override
    public final Cursor setString(int sym, String str) {
        return this.setLeaf(sym, StringValue.create(str));
    }

    @Override
    public final Cursor setString(int sym, byte[] utf8) {
        return this.setLeaf(sym, Utf8Value.create(utf8));
    }

    @Override
    public final Cursor setData(int sym, byte[] data) {
        return this.setLeaf(sym, DataValue.create(data));
    }

    protected Cursor setLeaf(String name, Value value) {
        return NixValue.invalid();
    }

    @Override
    public Cursor setArray(String name) {
        return NixValue.invalid();
    }

    @Override
    public Cursor setObject(String name) {
        return NixValue.invalid();
    }

    @Override
    public final Cursor setNix(String name) {
        return this.setLeaf(name, (Value)NixValue.instance());
    }

    @Override
    public final Cursor setBool(String name, boolean bit) {
        return this.setLeaf(name, (Value)BoolValue.instance(bit));
    }

    @Override
    public final Cursor setLong(String name, long l) {
        return this.setLeaf(name, (Value)new LongValue(l));
    }

    @Override
    public final Cursor setDouble(String name, double d) {
        return this.setLeaf(name, (Value)new DoubleValue(d));
    }

    @Override
    public final Cursor setString(String name, String str) {
        return this.setLeaf(name, StringValue.create(str));
    }

    @Override
    public final Cursor setString(String name, byte[] utf8) {
        return this.setLeaf(name, Utf8Value.create(utf8));
    }

    @Override
    public final Cursor setData(String name, byte[] data) {
        return this.setLeaf(name, DataValue.create(data));
    }

    public final String toString() {
        try {
            ByteArrayOutputStream a = new ByteArrayOutputStream();
            new JsonFormat(true).encode((OutputStream)a, (Inspector)this);
            byte[] utf8 = a.toByteArray();
            return Utf8Codec.decode(utf8, 0, utf8.length);
        }
        catch (Exception e) {
            return "null";
        }
    }

    @Override
    public boolean equalTo(Inspector that) {
        boolean equal;
        boolean bl = equal = this.type() == that.type();
        if (equal) {
            switch (this.type()) {
                case NIX: {
                    equal = this.valid() == that.valid();
                    break;
                }
                case BOOL: {
                    equal = this.asBool() == that.asBool();
                    break;
                }
                case LONG: {
                    equal = this.asLong() == that.asLong();
                    break;
                }
                case DOUBLE: {
                    equal = Double.compare(this.asDouble(), that.asDouble()) == 0;
                    break;
                }
                case STRING: {
                    equal = this.asString().equals(that.asString());
                    break;
                }
                case DATA: {
                    equal = Arrays.equals(this.asData(), that.asData());
                    break;
                }
                case ARRAY: {
                    EqualArray traverser = new EqualArray(that);
                    this.traverse(traverser);
                    equal = traverser.isEqual() && this.entries() == that.entries();
                    break;
                }
                case OBJECT: {
                    EqualObject traverser = new EqualObject(that);
                    this.traverse(traverser);
                    equal = traverser.isEqual() && this.fields() == that.fields();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        return equal;
    }

    private static class EqualArray
    extends Equal
    implements ArrayTraverser {
        public EqualArray(Inspector rhsInspector) {
            super(rhsInspector);
        }

        @Override
        public void entry(int idx, Inspector inspector) {
            if (this.equal) {
                this.equal = inspector.equalTo(this.rhsInspector.entry(idx));
            }
        }
    }

    private static class EqualObject
    extends Equal
    implements ObjectTraverser {
        public EqualObject(Inspector rhsInspector) {
            super(rhsInspector);
        }

        @Override
        public void field(String name, Inspector inspector) {
            if (this.equal) {
                this.equal = inspector.equalTo(this.rhsInspector.field(name));
            }
        }
    }

    private static class Equal {
        protected final Inspector rhsInspector;
        protected boolean equal = true;

        public Equal(Inspector rhsInspector) {
            this.rhsInspector = rhsInspector;
        }

        public boolean isEqual() {
            return this.equal;
        }
    }
}

