/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.text;

import java.util.OptionalInt;

public final class Text {
    private static final boolean[] allowedAsciiChars;

    private Text() {
    }

    public static boolean isTextCharacter(int codepoint) {
        if (codepoint < 128) {
            return allowedAsciiChars[codepoint];
        }
        if (codepoint < 64976) {
            return true;
        }
        if (codepoint <= 64991) {
            return false;
        }
        if (codepoint < 131070) {
            return true;
        }
        if (codepoint <= 131071) {
            return false;
        }
        if (codepoint < 196606) {
            return true;
        }
        if (codepoint <= 196607) {
            return false;
        }
        if (codepoint < 262142) {
            return true;
        }
        if (codepoint <= 262143) {
            return false;
        }
        if (codepoint < 327678) {
            return true;
        }
        if (codepoint <= 327679) {
            return false;
        }
        if (codepoint < 393214) {
            return true;
        }
        if (codepoint <= 393215) {
            return false;
        }
        if (codepoint < 458750) {
            return true;
        }
        if (codepoint <= 458751) {
            return false;
        }
        if (codepoint < 524286) {
            return true;
        }
        if (codepoint <= 524287) {
            return false;
        }
        if (codepoint < 589822) {
            return true;
        }
        if (codepoint <= 589823) {
            return false;
        }
        if (codepoint < 655358) {
            return true;
        }
        if (codepoint <= 655359) {
            return false;
        }
        if (codepoint < 720894) {
            return true;
        }
        if (codepoint <= 720895) {
            return false;
        }
        if (codepoint < 786430) {
            return true;
        }
        if (codepoint <= 786431) {
            return false;
        }
        if (codepoint < 851966) {
            return true;
        }
        if (codepoint <= 851967) {
            return false;
        }
        if (codepoint < 917502) {
            return true;
        }
        if (codepoint <= 917503) {
            return false;
        }
        if (codepoint < 983038) {
            return true;
        }
        if (codepoint <= 983039) {
            return false;
        }
        if (codepoint < 1048574) {
            return true;
        }
        if (codepoint <= 1048575) {
            return false;
        }
        if (codepoint < 1114110) {
            return true;
        }
        return codepoint > 0x10FFFF;
    }

    public static OptionalInt validateTextString(String string) {
        int charCount;
        for (int i = 0; i < string.length(); i += charCount) {
            int codePoint = string.codePointAt(i);
            if (!Text.isTextCharacter(codePoint)) {
                return OptionalInt.of(codePoint);
            }
            charCount = Character.charCount(codePoint);
            if (!Character.isHighSurrogate(string.charAt(i))) continue;
            if (charCount == 1) {
                return OptionalInt.of(string.codePointAt(i));
            }
            if (Character.isLowSurrogate(string.charAt(i + 1))) continue;
            return OptionalInt.of(string.codePointAt(i + 1));
        }
        return OptionalInt.empty();
    }

    public static boolean isDisplayable(int codePoint) {
        switch (Character.getType(codePoint)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                return true;
            }
        }
        return false;
    }

    private static StringBuilder lazy(StringBuilder sb, String s, int i) {
        if (sb == null) {
            sb = new StringBuilder(s.substring(0, i));
        }
        sb.append(' ');
        return sb;
    }

    public static String stripInvalidCharacters(String string) {
        int charCount;
        StringBuilder stripped = null;
        for (int i = 0; i < string.length(); i += charCount) {
            int codePoint = string.codePointAt(i);
            charCount = Character.charCount(codePoint);
            if (!Text.isTextCharacter(codePoint)) {
                stripped = Text.lazy(stripped, string, i);
                continue;
            }
            if (Character.isHighSurrogate(string.charAt(i))) {
                if (charCount == 1) {
                    stripped = Text.lazy(stripped, string, i);
                    continue;
                }
                if (!Character.isLowSurrogate(string.charAt(i + 1))) {
                    stripped = Text.lazy(stripped, string, i);
                    continue;
                }
                if (stripped == null) continue;
                stripped.appendCodePoint(codePoint);
                continue;
            }
            if (stripped == null) continue;
            stripped.appendCodePoint(codePoint);
        }
        return stripped != null ? stripped.toString() : string;
    }

    static {
        int i;
        allowedAsciiChars = new boolean[128];
        Text.allowedAsciiChars[0] = false;
        Text.allowedAsciiChars[1] = false;
        Text.allowedAsciiChars[2] = false;
        Text.allowedAsciiChars[3] = false;
        Text.allowedAsciiChars[4] = false;
        Text.allowedAsciiChars[5] = false;
        Text.allowedAsciiChars[6] = false;
        Text.allowedAsciiChars[7] = false;
        Text.allowedAsciiChars[8] = false;
        Text.allowedAsciiChars[9] = true;
        Text.allowedAsciiChars[10] = true;
        Text.allowedAsciiChars[11] = false;
        Text.allowedAsciiChars[12] = false;
        Text.allowedAsciiChars[13] = true;
        for (i = 14; i < 32; ++i) {
            Text.allowedAsciiChars[i] = false;
        }
        for (i = 32; i < 127; ++i) {
            Text.allowedAsciiChars[i] = true;
        }
        Text.allowedAsciiChars[127] = true;
    }
}

