/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.slime;

import com.yahoo.slime.NixValue;
import com.yahoo.slime.Type;
import com.yahoo.slime.Utf8Codec;
import com.yahoo.slime.Value;
import com.yahoo.slime.Visitor;

final class StringValue
extends Value {
    private final String value;
    private byte[] utf8;

    private StringValue(String value) {
        this.value = value;
    }

    public static Value create(String value) {
        if (value == null) {
            return NixValue.instance();
        }
        return new StringValue(value);
    }

    @Override
    public final Type type() {
        return Type.STRING;
    }

    @Override
    public final String asString() {
        return this.value;
    }

    @Override
    public final byte[] asUtf8() {
        if (this.utf8 == null) {
            this.utf8 = Utf8Codec.encode(this.value);
        }
        return this.utf8;
    }

    @Override
    public final void accept(Visitor v) {
        v.visitString(this.value);
    }
}

