/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.concurrent;

import com.yahoo.collections.Tuple2;

public class Receiver<T> {
    private final Object lock = new Object();
    private T message = null;
    private boolean received = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(T message) {
        Object object = this.lock;
        synchronized (object) {
            if (this.received) {
                throw new IllegalStateException("Multiple puts on a single Receiver instance is not legal.");
            }
            this.message = message;
            this.received = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuple2<MessageState, T> get(long timeout) throws InterruptedException {
        long barrier = System.currentTimeMillis() + timeout;
        Object object = this.lock;
        synchronized (object) {
            while (!this.received) {
                long t = System.currentTimeMillis();
                if (t >= barrier) {
                    return new Tuple2<MessageState, Object>(MessageState.TIMEOUT, null);
                }
                this.lock.wait(barrier - t);
            }
            return new Tuple2<MessageState, T>(MessageState.VALID, this.message);
        }
    }

    public static enum MessageState {
        VALID,
        TIMEOUT;

    }
}

