/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor;

import com.yahoo.tensor.TensorType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TensorTypeParser {
    private static final String START_STRING = "tensor";
    private static final String END_STRING = ")";
    private static final Pattern indexedPattern = Pattern.compile("(\\w+)\\[(\\d*)\\]");
    private static final Pattern mappedPattern = Pattern.compile("(\\w+)\\{\\}");

    public static TensorType fromSpec(String specString) {
        String dimensionsSpec;
        TensorType.Value valueType;
        if (!(specString = specString.trim()).startsWith(START_STRING) || !specString.endsWith(END_STRING)) {
            throw TensorTypeParser.formatException(specString);
        }
        String specBody = specString.substring(START_STRING.length(), specString.length() - END_STRING.length());
        if (specBody.startsWith("(")) {
            valueType = TensorType.Value.DOUBLE;
            dimensionsSpec = specBody.substring(1);
        } else {
            int parenthesisIndex = specBody.indexOf("(");
            if (parenthesisIndex < 0) {
                throw TensorTypeParser.formatException(specString);
            }
            valueType = TensorTypeParser.parseValueTypeSpec(specBody.substring(0, parenthesisIndex), specString);
            dimensionsSpec = specBody.substring(parenthesisIndex + 1);
        }
        if (dimensionsSpec.isEmpty()) {
            return new TensorType.Builder(valueType, Collections.emptyList()).build();
        }
        ArrayList<TensorType.Dimension> dimensions = new ArrayList<TensorType.Dimension>();
        for (String element : dimensionsSpec.split(",")) {
            boolean success;
            String trimmedElement = element.trim();
            boolean bl = success = TensorTypeParser.tryParseIndexedDimension(trimmedElement, dimensions) || TensorTypeParser.tryParseMappedDimension(trimmedElement, dimensions);
            if (success) continue;
            throw TensorTypeParser.formatException(specString, "Dimension '" + element + "' is on the wrong format");
        }
        return new TensorType.Builder(valueType, dimensions).build();
    }

    public static TensorType.Value toValueType(String valueTypeString) {
        switch (valueTypeString) {
            case "double": {
                return TensorType.Value.DOUBLE;
            }
            case "float": {
                return TensorType.Value.FLOAT;
            }
        }
        throw new IllegalArgumentException("Value type must be either 'double' or 'float' but was '" + valueTypeString + "'");
    }

    private static TensorType.Value parseValueTypeSpec(String valueTypeSpec, String fullSpecString) {
        if (!valueTypeSpec.startsWith("<") || !valueTypeSpec.endsWith(">")) {
            throw TensorTypeParser.formatException(fullSpecString, Optional.of("Value type spec must be enclosed in <>"));
        }
        try {
            return TensorTypeParser.toValueType(valueTypeSpec.substring(1, valueTypeSpec.length() - 1));
        }
        catch (IllegalArgumentException e) {
            throw TensorTypeParser.formatException(fullSpecString, e.getMessage());
        }
    }

    private static boolean tryParseIndexedDimension(String element, List<TensorType.Dimension> dimensions) {
        Matcher matcher = indexedPattern.matcher(element);
        if (matcher.matches()) {
            String dimensionName = matcher.group(1);
            String dimensionSize = matcher.group(2);
            if (dimensionSize.isEmpty()) {
                dimensions.add(TensorType.Dimension.indexed(dimensionName));
            } else {
                dimensions.add(TensorType.Dimension.indexed(dimensionName, Integer.valueOf(dimensionSize).intValue()));
            }
            return true;
        }
        return false;
    }

    private static boolean tryParseMappedDimension(String element, List<TensorType.Dimension> dimensions) {
        Matcher matcher = mappedPattern.matcher(element);
        if (matcher.matches()) {
            String dimensionName = matcher.group(1);
            dimensions.add(TensorType.Dimension.mapped(dimensionName));
            return true;
        }
        return false;
    }

    private static IllegalArgumentException formatException(String spec) {
        return TensorTypeParser.formatException(spec, Optional.empty());
    }

    private static IllegalArgumentException formatException(String spec, String errorDetail) {
        return TensorTypeParser.formatException(spec, Optional.of(errorDetail));
    }

    private static IllegalArgumentException formatException(String spec, Optional<String> errorDetail) {
        throw new IllegalArgumentException("A tensor type spec must be on the form tensor[<valuetype>]?(dimensionidentifier[{}|[length]*), but was '" + spec + "'. " + errorDetail.map(s -> s + ". ").orElse("") + "Examples: tensor(x[3]), tensor<float>(name{}, x[10])");
    }
}

