/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.tensor;

import com.google.common.collect.ImmutableMap;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.DoubleBinaryOperator;

public class MappedTensor
implements Tensor {
    private final TensorType type;
    private final ImmutableMap<TensorAddress, Double> cells;

    private MappedTensor(TensorType type, Map<TensorAddress, Double> cells) {
        this.type = type;
        this.cells = ImmutableMap.copyOf(cells);
    }

    @Override
    public TensorType type() {
        return this.type;
    }

    @Override
    public long size() {
        return this.cells.size();
    }

    @Override
    public double get(TensorAddress address) {
        return (Double)this.cells.getOrDefault((Object)address, (Object)Double.NaN);
    }

    @Override
    public Iterator<Tensor.Cell> cellIterator() {
        return new CellIteratorAdaptor((Iterator<Map.Entry<TensorAddress, Double>>)this.cells.entrySet().iterator());
    }

    @Override
    public Iterator<Double> valueIterator() {
        return this.cells.values().iterator();
    }

    @Override
    public Map<TensorAddress, Double> cells() {
        return this.cells;
    }

    @Override
    public Tensor withType(TensorType other) {
        if (!this.type.isRenamableTo(this.type)) {
            throw new IllegalArgumentException("MappedTensor.withType: types are not compatible. Current type: '" + this.type.toString() + "', requested type: '" + this.type.toString() + "'");
        }
        return new MappedTensor(other, (Map<TensorAddress, Double>)this.cells);
    }

    @Override
    public Tensor merge(DoubleBinaryOperator op, Map<TensorAddress, Double> addCells) {
        Tensor.Builder builder = Tensor.Builder.of(this.type());
        for (Map.Entry entry : this.cells.entrySet()) {
            TensorAddress address = (TensorAddress)entry.getKey();
            double value = (Double)entry.getValue();
            builder.cell(address, addCells.containsKey(address) ? op.applyAsDouble(value, addCells.get(address)) : value);
        }
        for (Map.Entry entry : addCells.entrySet()) {
            if (this.cells.containsKey(entry.getKey())) continue;
            builder.cell((TensorAddress)entry.getKey(), (double)((Double)entry.getValue()));
        }
        return builder.build();
    }

    @Override
    public Tensor remove(Set<TensorAddress> addresses) {
        Tensor.Builder builder = Tensor.Builder.of(this.type());
        Iterator<Tensor.Cell> i = this.cellIterator();
        while (i.hasNext()) {
            Tensor.Cell cell = i.next();
            TensorAddress address = cell.getKey();
            if (addresses.contains(address)) continue;
            builder.cell(address, (double)cell.getValue());
        }
        return builder.build();
    }

    public int hashCode() {
        return this.cells.hashCode();
    }

    @Override
    public String toString() {
        return Tensor.toStandardString(this);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Tensor)) {
            return false;
        }
        return Tensor.equals(this, (Tensor)other);
    }

    private static class CellIteratorAdaptor
    implements Iterator<Tensor.Cell> {
        private final Iterator<Map.Entry<TensorAddress, Double>> adaptedIterator;

        private CellIteratorAdaptor(Iterator<Map.Entry<TensorAddress, Double>> adaptedIterator) {
            this.adaptedIterator = adaptedIterator;
        }

        @Override
        public boolean hasNext() {
            return this.adaptedIterator.hasNext();
        }

        @Override
        public Tensor.Cell next() {
            Map.Entry<TensorAddress, Double> entry = this.adaptedIterator.next();
            return new Tensor.Cell(entry.getKey(), entry.getValue());
        }
    }

    public static class Builder
    implements Tensor.Builder {
        private final TensorType type;
        private final ImmutableMap.Builder<TensorAddress, Double> cells = new ImmutableMap.Builder();

        public static Builder of(TensorType type) {
            return new Builder(type);
        }

        private Builder(TensorType type) {
            this.type = type;
        }

        @Override
        public Tensor.Builder.CellBuilder cell() {
            return new Tensor.Builder.CellBuilder(this.type, this);
        }

        @Override
        public TensorType type() {
            return this.type;
        }

        @Override
        public Builder cell(TensorAddress address, float value) {
            return this.cell(address, (double)value);
        }

        @Override
        public Builder cell(TensorAddress address, double value) {
            this.cells.put((Object)address, (Object)value);
            return this;
        }

        @Override
        public Builder cell(float value, long ... labels) {
            return this.cell((double)value, labels);
        }

        @Override
        public Builder cell(double value, long ... labels) {
            this.cells.put((Object)TensorAddress.of(labels), (Object)value);
            return this;
        }

        @Override
        public MappedTensor build() {
            return new MappedTensor(this.type, (Map<TensorAddress, Double>)this.cells.build());
        }
    }
}

