/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.geo;

import com.google.common.annotations.Beta;

@Beta
public class DistanceParser {
    public static final double m2deg = 9.013373419803436E-6;
    public static final double km2deg = 0.009013373419803435;
    public static final double mi2deg = 0.014505618432920139;
    private final double degrees;

    public double getDegrees() {
        return this.degrees;
    }

    public static double parse(String distance) {
        DistanceParser parser = new DistanceParser(distance, false);
        return parser.degrees;
    }

    DistanceParser(String distance, boolean assumeMicroDegrees) {
        if (distance.endsWith(" km")) {
            double km = Double.valueOf(distance.substring(0, distance.length() - 3));
            this.degrees = km * 0.009013373419803435;
        } else if (distance.endsWith(" m")) {
            double meters = Double.valueOf(distance.substring(0, distance.length() - 2));
            this.degrees = meters * 9.013373419803436E-6;
        } else if (distance.endsWith(" miles")) {
            double miles = Double.valueOf(distance.substring(0, distance.length() - 6));
            this.degrees = miles * 0.014505618432920139;
        } else if (distance.endsWith(" mi")) {
            double miles = Double.valueOf(distance.substring(0, distance.length() - 3));
            this.degrees = miles * 0.014505618432920139;
        } else if (distance.endsWith(" deg")) {
            this.degrees = Double.valueOf(distance.substring(0, distance.length() - 4));
        } else if (distance.endsWith(" d")) {
            this.degrees = Double.valueOf(distance.substring(0, distance.length() - 2));
        } else if (distance.endsWith("km")) {
            double km = Double.valueOf(distance.substring(0, distance.length() - 2));
            this.degrees = km * 0.009013373419803435;
        } else if (distance.endsWith("m")) {
            double meters = Double.valueOf(distance.substring(0, distance.length() - 1));
            this.degrees = meters * 9.013373419803436E-6;
        } else if (distance.endsWith("miles")) {
            double miles = Double.valueOf(distance.substring(0, distance.length() - 5));
            this.degrees = miles * 0.014505618432920139;
        } else if (distance.endsWith("mi")) {
            double miles = Double.valueOf(distance.substring(0, distance.length() - 2));
            this.degrees = miles * 0.014505618432920139;
        } else if (distance.endsWith("deg")) {
            this.degrees = Double.valueOf(distance.substring(0, distance.length() - 3));
        } else if (distance.endsWith("d")) {
            this.degrees = Double.valueOf(distance.substring(0, distance.length() - 1));
        } else if (assumeMicroDegrees) {
            this.degrees = (double)Integer.parseInt(distance) * 1.0E-6;
        } else {
            throw new IllegalArgumentException("missing unit for distance: " + distance);
        }
    }
}

