/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.concurrent.maintenance;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;

public class JobMetrics {
    private final BiConsumer<String, Long> metricConsumer;
    private final ConcurrentHashMap<String, Long> incompleteRuns = new ConcurrentHashMap();

    public JobMetrics(BiConsumer<String, Long> metricConsumer) {
        this.metricConsumer = metricConsumer;
    }

    public void recordRunOf(String job) {
        this.incompleteRuns.merge(job, 1L, Long::sum);
    }

    public void recordCompletionOf(String job) {
        this.incompleteRuns.put(job, 0L);
    }

    public void forward(String job) {
        Long incompleteRuns = this.incompleteRuns.get(job);
        if (incompleteRuns != null) {
            this.metricConsumer.accept(job, incompleteRuns);
        }
    }
}

