/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.slime;

final class BufferedOutput {
    private byte[] buf;
    private int capacity;
    private int pos;

    public BufferedOutput(int cap) {
        this.capacity = cap < 64 ? 64 : cap;
        this.buf = new byte[this.capacity];
    }

    public BufferedOutput() {
        this(4096);
    }

    public void reset() {
        this.pos = 0;
    }

    private void reserve(int bytes) {
        if (this.pos + bytes > this.capacity) {
            while (this.pos + bytes > this.capacity) {
                this.capacity *= 2;
            }
            byte[] tmp = new byte[this.capacity];
            System.arraycopy(this.buf, 0, tmp, 0, this.pos);
            this.buf = tmp;
        }
    }

    public int position() {
        return this.pos;
    }

    final void put(byte b) {
        this.reserve(1);
        this.buf[this.pos++] = b;
    }

    final void absolutePut(int position, byte b) {
        this.buf[position] = b;
    }

    final void put(byte[] bytes) {
        this.reserve(bytes.length);
        for (byte b : bytes) {
            this.buf[this.pos++] = b;
        }
    }

    public byte[] toArray() {
        byte[] ret = new byte[this.pos];
        System.arraycopy(this.buf, 0, ret, 0, this.pos);
        return ret;
    }
}

