/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.concurrent.maintenance;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;

public class JobMetrics {
    private final BiConsumer<String, Long> metricConsumer;
    private final Map<String, Long> incompleteRuns = new ConcurrentHashMap<String, Long>();

    public JobMetrics(BiConsumer<String, Long> metricConsumer) {
        this.metricConsumer = metricConsumer;
    }

    public void recordRunOf(String job) {
        this.incompleteRuns.compute(job, (ignored, run) -> {
            long l;
            if (run == null) {
                l = 1L;
            } else {
                run = run + 1L;
                l = run;
            }
            return l;
        });
    }

    public void recordSuccessOf(String job) {
        this.incompleteRuns.put(job, 0L);
    }

    public void forward(String job) {
        Long incompleteRuns = this.incompleteRuns.get(job);
        if (incompleteRuns != null) {
            this.metricConsumer.accept(job, incompleteRuns);
        }
    }
}

