/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.text;

import com.yahoo.text.Utf8;
import com.yahoo.text.Utf8Array;
import java.nio.ByteBuffer;

public abstract class AbstractUtf8Array
implements Comparable<AbstractUtf8Array> {
    public final void writeTo(ByteBuffer target) {
        target.put(this.getBytes(), this.getByteOffset(), this.getByteLength());
    }

    public byte getByte(int index) {
        return this.getBytes()[this.getByteOffset() + index];
    }

    public abstract int getByteLength();

    public ByteBuffer wrap() {
        return ByteBuffer.wrap(this.getBytes(), this.getByteOffset(), this.getByteLength());
    }

    protected abstract byte[] getBytes();

    public boolean isEmpty() {
        return this.getByteLength() == 0;
    }

    protected abstract int getByteOffset();

    public int hashCode() {
        int l = this.getByteLength();
        int c = this.getByteOffset();
        byte[] b = this.getBytes();
        int h = 0;
        for (int i = 0; i < l; ++i) {
            byte v = b[c + i];
            h ^= v << i % 4 * 8;
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractUtf8Array) {
            AbstractUtf8Array other = (AbstractUtf8Array)o;
            return this.compareTo(other) == 0;
        }
        if (o instanceof String) {
            return this.toString().equals(o);
        }
        return false;
    }

    public String toString() {
        return Utf8.toString(this.getBytes(), this.getByteOffset(), this.getByteLength());
    }

    @Override
    public int compareTo(AbstractUtf8Array rhs) {
        int rl;
        int l = this.getByteLength();
        if (l < (rl = rhs.getByteLength())) {
            return -1;
        }
        if (l > rl) {
            return 1;
        }
        byte[] b = this.getBytes();
        byte[] rb = rhs.getBytes();
        int c = this.getByteOffset();
        int rc = rhs.getByteOffset();
        for (int i = 0; i < l; ++i) {
            if (b[c + i] < rb[rc + i]) {
                return -1;
            }
            if (b[c + i] <= rb[rc + i]) continue;
            return 1;
        }
        return 0;
    }

    public Utf8Array ascii7BitLowerCase() {
        byte[] upper = new byte[this.getByteLength()];
        for (int i = 0; i < upper.length; ++i) {
            byte b = this.getByte(i);
            if (b >= 65 && b < 91) {
                b = (byte)(b | 0x20);
            }
            upper[i] = b;
        }
        return new Utf8Array(upper);
    }
}

